/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.protocol;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.CheckedIterator;
import com.github.housepower.jdbc.misc.CheckedSupplier;
import com.github.housepower.jdbc.protocol.DataResponse;
import com.github.housepower.jdbc.protocol.EOFStreamResponse;
import com.github.housepower.jdbc.protocol.RequestOrResponse;
import java.sql.SQLException;
import java.util.function.Supplier;

public class QueryResponse {
    private final CheckedSupplier<RequestOrResponse, SQLException> responseSupplier;
    private Block header;
    private boolean atEnd;

    public QueryResponse(CheckedSupplier<RequestOrResponse, SQLException> responseSupplier) {
        this.responseSupplier = responseSupplier;
    }

    public Block header() throws SQLException {
        this.ensureHeaderConsumed();
        return this.header;
    }

    private void ensureHeaderConsumed() throws SQLException {
        if (this.header == null) {
            DataResponse firstDataResponse = this.consumeDataResponse();
            this.header = firstDataResponse != null ? firstDataResponse.block() : new Block();
        }
    }

    private DataResponse consumeDataResponse() throws SQLException {
        while (!this.atEnd) {
            RequestOrResponse response = this.responseSupplier.get();
            if (response instanceof DataResponse) {
                return (DataResponse)response;
            }
            if (!(response instanceof EOFStreamResponse) && response != null) continue;
            this.atEnd = true;
        }
        return null;
    }

    public Supplier<CheckedIterator<DataResponse, SQLException>> data() {
        return () -> new CheckedIterator<DataResponse, SQLException>(){
            DataResponse current;

            private DataResponse fill() throws SQLException {
                QueryResponse.this.ensureHeaderConsumed();
                this.current = QueryResponse.this.consumeDataResponse();
                return this.current;
            }

            private DataResponse drain() throws SQLException {
                if (this.current == null) {
                    this.fill();
                }
                DataResponse top = this.current;
                this.current = null;
                return top;
            }

            @Override
            public boolean hasNext() throws SQLException {
                return this.current != null || this.fill() != null;
            }

            @Override
            public DataResponse next() throws SQLException {
                return this.drain();
            }
        };
    }
}

