/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.protocol;

import com.github.housepower.jdbc.protocol.ProtocolType;
import com.github.housepower.jdbc.protocol.RequestOrResponse;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import java.io.IOException;

public class HelloRequest
extends RequestOrResponse {
    private final String clientName;
    private final long clientReversion;
    private final String defaultDatabase;
    private final String clientUsername;
    private final String clientPassword;

    public HelloRequest(String clientName, long clientReversion, String defaultDatabase, String clientUsername, String clientPassword) {
        super(ProtocolType.REQUEST_HELLO);
        this.clientName = clientName;
        this.clientReversion = clientReversion;
        this.defaultDatabase = defaultDatabase;
        this.clientUsername = clientUsername;
        this.clientPassword = clientPassword;
    }

    @Override
    public void writeImpl(BinarySerializer serializer) throws IOException {
        serializer.writeStringBinary("ClickHouse " + this.clientName);
        serializer.writeVarInt(ClickHouseDefines.MAJOR_VERSION.intValue());
        serializer.writeVarInt(ClickHouseDefines.MINOR_VERSION.intValue());
        serializer.writeVarInt(this.clientReversion);
        serializer.writeStringBinary(this.defaultDatabase);
        serializer.writeStringBinary(this.clientUsername);
        serializer.writeStringBinary(this.clientPassword);
    }
}

