/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.misc;

import com.github.housepower.jdbc.misc.StringView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class StringViewCoding {
    private static Field stringValuesField;
    private static Method encodeBytesMethod;

    public static byte[] bytes(StringView data) throws SQLException {
        try {
            Method encodeBytesMethod = StringViewCoding.getEncodeBytesMethod();
            return (byte[])encodeBytesMethod.invoke(null, data.values(), data.start(), data.end() - data.start());
        }
        catch (Exception e) {
            throw new SQLException("Cannot get java.lang.StringCoding encode Method", e);
        }
    }

    public static char[] getValues(String data) throws SQLException {
        try {
            Field field = StringViewCoding.getStringValueReflectField();
            return (char[])field.get(data);
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot get java.lang.String values field", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field getStringValueReflectField() throws SQLException {
        if (stringValuesField != null) return stringValuesField;
        Class<StringViewCoding> clazz = StringViewCoding.class;
        synchronized (StringViewCoding.class) {
            if (stringValuesField != null) return stringValuesField;
            try {
                Field stringValueField = String.class.getDeclaredField("value");
                stringValueField.setAccessible(true);
                stringValuesField = stringValueField;
            }
            catch (NoSuchFieldException e) {
                throw new SQLException("Cannot get java.lang.String values field", e);
            }
            return stringValuesField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Method getEncodeBytesMethod() throws SQLException {
        if (encodeBytesMethod != null) return encodeBytesMethod;
        Class<StringViewCoding> clazz = StringViewCoding.class;
        synchronized (StringViewCoding.class) {
            if (encodeBytesMethod != null) return encodeBytesMethod;
            try {
                Class<?> codingClazz = Class.forName("java.lang.StringCoding");
                Method encodeBytesMethod = codingClazz.getDeclaredMethod("encode", char[].class, Integer.TYPE, Integer.TYPE);
                encodeBytesMethod.setAccessible(true);
                StringViewCoding.encodeBytesMethod = encodeBytesMethod;
            }
            catch (Exception e) {
                throw new SQLException("Cannot get java.lang.String values field", e);
            }
            return encodeBytesMethod;
        }
    }
}

