/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.ClickHouseStruct;
import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;

public class DataTypeTuple
implements IDataType {
    private final String name;
    private final IDataType[] nestedTypes;

    public DataTypeTuple(String name, IDataType[] nestedTypes) {
        this.name = name;
        this.nestedTypes = nestedTypes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2002;
    }

    @Override
    public Object defaultValue() {
        Object[] attrs = new Object[this.nestedTypes.length];
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            attrs[i] = this.nestedTypes[i].defaultValue();
        }
        return new ClickHouseStruct("Tuple", attrs);
    }

    @Override
    public Class javaTypeClass() {
        return Struct.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        Validate.isTrue(data instanceof Struct && "Tuple".equals(((Struct)data).getSQLTypeName()), "Expected Struct Parameter, but was " + data.getClass().getSimpleName());
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            this.nestedTypes[i].serializeBinary(((Struct)data).getAttributes()[i], serializer);
        }
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] attrs = new Object[this.nestedTypes.length];
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            attrs[i] = this.nestedTypes[i].deserializeBinary(deserializer);
        }
        return new ClickHouseStruct("Tuple", attrs);
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            Object[] elemsData = new Object[data.length];
            for (int row = 0; row < data.length; ++row) {
                Validate.isTrue(data[row] instanceof Struct && "Tuple".equals(((Struct)data[row]).getSQLTypeName()), "Expected Struct Parameter, but was " + data.getClass().getSimpleName());
                elemsData[row] = ((Struct)data[row]).getAttributes()[i];
            }
            this.nestedTypes[i].serializeBinaryBulk(elemsData, serializer);
        }
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[][] rowsWithElems = this.getRowsWithElems(rows, deserializer);
        Object[] rowsData = new Struct[rows];
        for (int row = 0; row < rows; ++row) {
            Object[] elemsData = new Object[this.nestedTypes.length];
            for (int elemIndex = 0; elemIndex < this.nestedTypes.length; ++elemIndex) {
                elemsData[elemIndex] = rowsWithElems[elemIndex][row];
            }
            rowsData[row] = new ClickHouseStruct("Tuple", elemsData);
        }
        return rowsData;
    }

    private Object[][] getRowsWithElems(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        Object[][] rowsWithElems = new Object[this.nestedTypes.length][];
        for (int index = 0; index < this.nestedTypes.length; ++index) {
            rowsWithElems[index] = this.nestedTypes[index].deserializeBinaryBulk(rows, deserializer);
        }
        return rowsWithElems;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '(');
        Object[] tupleData = new Object[this.nestedTypes.length];
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            if (i > 0) {
                Validate.isTrue(lexer.character() == ',');
            }
            tupleData[i] = this.nestedTypes[i].deserializeTextQuoted(lexer);
        }
        Validate.isTrue(lexer.character() == ')');
        return new ClickHouseStruct("Tuple", tupleData);
    }

    public static DataTypeTuple createTupleType(SQLLexer lexer, PhysicalInfo.ServerInfo serverInfo) throws SQLException {
        char delimiter;
        Validate.isTrue(lexer.character() == '(');
        ArrayList<IDataType> nestedDataTypes = new ArrayList<IDataType>();
        do {
            nestedDataTypes.add(DataTypeFactory.get(lexer, serverInfo));
            delimiter = lexer.character();
            Validate.isTrue(delimiter == ',' || delimiter == ')');
        } while (delimiter != ')');
        StringBuilder builder = new StringBuilder("Tuple(");
        for (int i = 0; i < nestedDataTypes.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(((IDataType)nestedDataTypes.get(i)).name());
        }
        return new DataTypeTuple(builder.append(")").toString(), nestedDataTypes.toArray(new IDataType[nestedDataTypes.size()]));
    }
}

