/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.ClickHouseArray;
import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;

public class DataTypeArray
implements IDataType {
    private final String name;
    private final Array defaultValue;
    private final IDataType elemDataType;
    private final IDataType offsetIDataType;

    public DataTypeArray(String name, IDataType elemDataType, IDataType offsetIDataType) throws SQLException {
        this.name = name;
        this.elemDataType = elemDataType;
        this.offsetIDataType = offsetIDataType;
        this.defaultValue = new ClickHouseArray(new Object[]{elemDataType.defaultValue()});
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2003;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class javaTypeClass() {
        return Array.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        char delimiter;
        Validate.isTrue(lexer.character() == '[');
        ArrayList<Object> arrayData = new ArrayList<Object>();
        do {
            arrayData.add(this.elemDataType.deserializeTextQuoted(lexer));
            delimiter = lexer.character();
            Validate.isTrue(delimiter == ',' || delimiter == ']');
        } while (delimiter != ']');
        return new ClickHouseArray(arrayData.toArray());
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        Validate.isTrue(data instanceof Array, "Expected Array Parameter, but was " + data.getClass().getSimpleName());
        this.offsetIDataType.serializeBinary(((Object[])((Array)data).getArray()).length, serializer);
        this.elemDataType.serializeBinaryBulk((Object[])((Array)data).getArray(), serializer);
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Long offset = (Long)this.offsetIDataType.deserializeBinary(deserializer);
        return this.elemDataType.deserializeBinaryBulk(offset.intValue(), deserializer);
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        Object[] arrayData;
        for (Object datum : data) {
            Validate.isTrue(datum instanceof Array, "Expected Array Parameter, but was " + datum.getClass().getSimpleName());
            arrayData = (Object[])((Array)datum).getArray();
            this.offsetIDataType.serializeBinary(arrayData.length, serializer);
        }
        for (Object datum : data) {
            Validate.isTrue(datum instanceof Array, "Expected Array Parameter, but was " + datum.getClass().getSimpleName());
            arrayData = (Object[])((Array)datum).getArray();
            this.elemDataType.serializeBinaryBulk(arrayData, serializer);
        }
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        Object[] data = new ClickHouseArray[rows];
        if (rows == 0) {
            return data;
        }
        Object[] offsets = this.offsetIDataType.deserializeBinaryBulk(rows, deserializer);
        ClickHouseArray res = new ClickHouseArray(this.elemDataType.deserializeBinaryBulk(((BigInteger)offsets[rows - 1]).intValue(), deserializer));
        int lastOffset = 0;
        for (int row = 0; row < rows; ++row) {
            BigInteger offset = (BigInteger)offsets[row];
            data[row] = res.slice(lastOffset, offset.intValue() - lastOffset);
            lastOffset = offset.intValue();
        }
        return data;
    }

    public static IDataType createArrayType(SQLLexer lexer, PhysicalInfo.ServerInfo serverInfo) throws SQLException {
        Validate.isTrue(lexer.character() == '(');
        IDataType arrayNestedType = DataTypeFactory.get(lexer, serverInfo);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeArray("Array(" + arrayNestedType.name() + ")", arrayNestedType, DataTypeFactory.get("UInt64", serverInfo));
    }
}

