/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type;

import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeFloat32
implements IDataType {
    private static final Float DEFAULT_VALUE = Float.valueOf(0.0f);

    @Override
    public String name() {
        return "Float32";
    }

    @Override
    public int sqlTypeId() {
        return 6;
    }

    @Override
    public Object defaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Class javaTypeClass() {
        return Float.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        Validate.isTrue(data instanceof Float, "Expected Float Parameter, but was " + data.getClass().getSimpleName());
        serializer.writeFloat(((Float)data).floatValue());
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        return Float.valueOf(deserializer.readFloat());
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        for (Object datum : data) {
            this.serializeBinary(datum, serializer);
        }
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException {
        Object[] data = new Float[rows];
        for (int row = 0; row < rows; ++row) {
            data[row] = Float.valueOf(deserializer.readFloat());
        }
        return data;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        return Float.valueOf(lexer.numberLiteral().floatValue());
    }
}

