/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.BlockSettings;
import com.github.housepower.jdbc.data.Column;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private final int rows;
    private final Column[] columns;
    private final BlockSettings settings;
    private final Map<String, Integer> nameWithPosition;

    public Block() {
        this(0, new Column[0]);
    }

    public Block(int rows, Column[] columns) {
        this(rows, columns, new BlockSettings(BlockSettings.Setting.values()));
    }

    public Block(int rows, Column[] columns, BlockSettings settings) {
        this.rows = rows;
        this.columns = columns;
        this.settings = settings;
        this.nameWithPosition = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            this.nameWithPosition.put(columns[i].name(), i + 1);
        }
    }

    public void writeTo(BinarySerializer serializer) throws IOException, SQLException {
        this.settings.writeTo(serializer);
        serializer.writeVarInt(this.columns.length);
        serializer.writeVarInt(this.rows);
        for (Column column : this.columns) {
            serializer.writeStringBinary(column.name());
            serializer.writeStringBinary(column.type().name());
            column.type().serializeBinaryBulk(column.data(), serializer);
        }
    }

    public long rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns.length;
    }

    public Column getByPosition(int column) throws SQLException {
        Validate.isTrue(column < this.columns.length, "Position " + column + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.columns[column];
    }

    public int getPositionByName(String name) throws SQLException {
        Validate.isTrue(this.nameWithPosition.containsKey(name));
        return this.nameWithPosition.get(name);
    }

    public static Block readFrom(BinaryDeserializer deserializer, PhysicalInfo.ServerInfo serverInfo) throws IOException, SQLException {
        BlockSettings info = BlockSettings.readFrom(deserializer);
        int columns = (int)deserializer.readVarInt();
        int rows = (int)deserializer.readVarInt();
        Column[] cols = new Column[columns];
        for (int i = 0; i < columns; ++i) {
            String name = deserializer.readStringBinary();
            String type = deserializer.readStringBinary();
            IDataType dataType = DataTypeFactory.get(type, serverInfo);
            cols[i] = new Column(name, dataType, dataType.deserializeBinaryBulk(rows, deserializer));
        }
        return new Block(rows, cols, info);
    }
}

