/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.buffer;

import com.github.housepower.jdbc.buffer.BuffedWriter;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class SocketBuffedWriter
implements BuffedWriter {
    private int position = 0;
    private int capacity = ClickHouseDefines.DEFAULT_BUFFER_SIZE;
    private final byte[] buf = new byte[this.capacity];
    private final OutputStream out;

    public SocketBuffedWriter(Socket socket) throws IOException {
        this.out = socket.getOutputStream();
    }

    @Override
    public void writeBinary(byte byt) throws IOException {
        this.buf[this.position++] = byt;
        this.flushToTarget(false);
    }

    @Override
    public void writeBinary(byte[] bytes) throws IOException {
        this.writeBinary(bytes, 0, bytes.length);
    }

    @Override
    public void writeBinary(byte[] bytes, int offset, int length) throws IOException {
        int i = offset;
        int max = offset + length;
        while (i < max) {
            if (this.remaining()) {
                int writtenNumber = Math.min(this.capacity - this.position, max - i);
                System.arraycopy(bytes, i, this.buf, this.position, writtenNumber);
                i += writtenNumber;
                this.position += writtenNumber;
            }
            this.flushToTarget(false);
        }
    }

    @Override
    public void flushToTarget(boolean force) throws IOException {
        if (force || !this.remaining()) {
            this.out.write(this.buf, 0, this.position);
            this.position = 0;
            this.out.flush();
        }
    }

    private boolean remaining() {
        return this.position < this.capacity;
    }
}

