/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.buffer;

import com.github.housepower.jdbc.buffer.BuffedReader;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SocketBuffedReader
implements BuffedReader {
    private int limit = 0;
    private int position = 0;
    private int capacity;
    private final byte[] buf;
    private final InputStream in;

    public SocketBuffedReader(Socket socket) throws IOException {
        this(socket.getInputStream(), ClickHouseDefines.DEFAULT_BUFFER_SIZE);
    }

    SocketBuffedReader(InputStream in, int capacity) {
        this.capacity = capacity;
        this.in = in;
        this.buf = new byte[capacity];
    }

    @Override
    public int readBinary() throws IOException {
        if (!this.remaining() && !this.refill()) {
            throw new EOFException("Attempt to read after eof.");
        }
        return this.buf[this.position++] & 0xFF;
    }

    @Override
    public int readBinary(byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            if (!this.remaining() && !this.refill()) {
                throw new EOFException("Attempt to read after eof.");
            }
            int pending = bytes.length - i;
            int fillLength = Math.min(pending, this.limit - this.position);
            if (fillLength <= 0) continue;
            System.arraycopy(this.buf, this.position, bytes, i, fillLength);
            i += fillLength;
            this.position += fillLength;
        }
        return bytes.length;
    }

    private boolean remaining() {
        return this.position < this.limit;
    }

    private boolean refill() throws IOException {
        if (!this.remaining() && (this.limit = this.in.read(this.buf, 0, this.capacity)) <= 0) {
            throw new EOFException("Attempt to read after eof.");
        }
        this.position = 0;
        return true;
    }
}

