/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeNullable;
import com.github.housepower.jdbc.wrapper.SQLResultSetMetaData;
import java.sql.SQLException;

public class ClickHouseResultSetMetaData
extends SQLResultSetMetaData {
    private final Block header;

    public ClickHouseResultSetMetaData(Block header) {
        this.header = header;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.header.columns();
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        IDataType type = this.header.getByPosition(index - 1).type();
        return type.sqlTypeId();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 80;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.header.getByPosition(column - 1).type().name();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.header.getByPosition(column - 1).type().javaTypeClass().getName();
    }

    @Override
    public String getColumnName(int index) throws SQLException {
        return this.getColumnLabel(index);
    }

    @Override
    public String getColumnLabel(int index) throws SQLException {
        return this.header.getByPosition(index - 1).name();
    }

    @Override
    public int isNullable(int index) throws SQLException {
        return this.header.getByPosition(index - 1).type() instanceof DataTypeNullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.header.getByPosition(index).name().startsWith("U");
    }

    @Override
    public boolean isReadOnly(int index) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int index) throws SQLException {
        return false;
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        return false;
    }
}

