/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.ClickHouseResultSetMetaData;
import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.data.Column;
import com.github.housepower.jdbc.misc.CheckedIterator;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.protocol.DataResponse;
import com.github.housepower.jdbc.statement.ClickHouseStatement;
import com.github.housepower.jdbc.wrapper.SQLResultSet;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;

public class ClickHouseResultSet
extends SQLResultSet {
    private int row = -1;
    private Block current = new Block();
    private int lastFetchRow = -1;
    private int lastFetchColumn = -1;
    private Block lastFetchBlock = null;
    private final Block header;
    private final ClickHouseStatement statement;
    private final CheckedIterator<DataResponse, SQLException> iterator;

    public ClickHouseResultSet(Block header, CheckedIterator<DataResponse, SQLException> iterator, ClickHouseStatement statement) {
        this.header = header;
        this.iterator = iterator;
        this.statement = statement;
    }

    @Override
    public int getInt(String name) throws SQLException {
        return this.getInt(this.findColumn(name));
    }

    @Override
    public URL getURL(String name) throws SQLException {
        return this.getURL(this.findColumn(name));
    }

    @Override
    public byte getByte(String name) throws SQLException {
        return this.getByte(this.findColumn(name));
    }

    @Override
    public Date getDate(String name) throws SQLException {
        return this.getDate(this.findColumn(name));
    }

    @Override
    public long getLong(String name) throws SQLException {
        return this.getLong(this.findColumn(name));
    }

    @Override
    public Array getArray(String name) throws SQLException {
        return this.getArray(this.findColumn(name));
    }

    @Override
    public float getFloat(String name) throws SQLException {
        return this.getFloat(this.findColumn(name));
    }

    @Override
    public short getShort(String name) throws SQLException {
        return this.getShort(this.findColumn(name));
    }

    @Override
    public double getDouble(String name) throws SQLException {
        return this.getDouble(this.findColumn(name));
    }

    @Override
    public String getString(String name) throws SQLException {
        return this.getString(this.findColumn(name));
    }

    @Override
    public Object getObject(String name) throws SQLException {
        return this.getObject(this.findColumn(name));
    }

    @Override
    public Timestamp getTimestamp(String name) throws SQLException {
        return this.getTimestamp(this.findColumn(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws SQLException {
        return this.getBigDecimal(this.findColumn(name));
    }

    @Override
    public int getInt(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).intValue();
    }

    @Override
    public URL getURL(int index) throws SQLException {
        try {
            return new URL(this.getString(index));
        }
        catch (MalformedURLException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte getByte(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).byteValue();
    }

    @Override
    public Date getDate(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Date);
        return (Date)data;
    }

    @Override
    public Date getDate(int index, Calendar cal) throws SQLException {
        return super.getDate(index, cal);
    }

    @Override
    public long getLong(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).longValue();
    }

    @Override
    public Array getArray(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Array);
        return (Array)data;
    }

    @Override
    public float getFloat(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).floatValue();
    }

    @Override
    public short getShort(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).shortValue();
    }

    @Override
    public double getDouble(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return ((Number)data).doubleValue();
    }

    @Override
    public String getString(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof String);
        return (String)data;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        Validate.isTrue(this.row >= 0 && (long)this.row < this.current.rows(), "No row information was obtained.You must call ResultSet.next() before that.");
        this.lastFetchBlock = this.current;
        this.lastFetchColumn = index - 1;
        Column column = this.lastFetchBlock.getByPosition(this.lastFetchColumn);
        this.lastFetchRow = this.row;
        Object rowData = column.data(this.lastFetchRow);
        return rowData == null ? column.type().defaultValue() : rowData;
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Timestamp);
        return (Timestamp)data;
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        Object data = this.getObject(index);
        Validate.isTrue(data instanceof Number);
        return new BigDecimal(data.toString());
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        Validate.isTrue(this.lastFetchBlock != null, "Please call Result.next()");
        Validate.isTrue(this.lastFetchColumn >= 0, "Please call Result.getXXX()");
        Validate.isTrue(this.lastFetchRow >= 0 && (long)this.lastFetchRow < this.lastFetchBlock.rows(), "Please call Result.next()");
        return this.lastFetchBlock.getByPosition(this.lastFetchColumn).data(this.lastFetchRow) == null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public int findColumn(String name) throws SQLException {
        return this.header.getPositionByName(name);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ClickHouseResultSetMetaData(this.header);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean next() throws SQLException {
        if ((long)(++this.row) < this.current.rows()) return true;
        this.row = 0;
        this.current = this.fetchBlock();
        if ((long)0 >= this.current.rows()) return false;
        return true;
    }

    private Block fetchBlock() throws SQLException {
        while (this.iterator.hasNext()) {
            DataResponse next = this.iterator.next();
            if (next.block().rows() <= 0L) continue;
            return next.block();
        }
        return new Block();
    }
}

