/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.repackaged.io.airlift.compress.lzo;

import com.github.housepower.repackaged.io.airlift.compress.lzo.HadoopLzoInputStream;
import com.github.housepower.repackaged.io.airlift.compress.lzo.HadoopLzoOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;

public class LzoCodec
implements Configurable,
CompressionCodec {
    public static final int LZO_BUFFER_SIZE_DEFAULT = 262144;
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopLzoOutputStream(out, this.getBufferSize());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopLzoCompressor)) {
            throw new IllegalArgumentException("Compressor is not the LZO compressor");
        }
        return new HadoopLzoOutputStream(out, this.getBufferSize());
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopLzoCompressor.class;
    }

    public Compressor createCompressor() {
        return new HadoopLzoCompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopLzoInputStream(in, this.getBufferSize());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopLzoDecompressor)) {
            throw new IllegalArgumentException("Decompressor is not the LZO decompressor");
        }
        return new HadoopLzoInputStream(in, this.getBufferSize());
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopLzoDecompressor.class;
    }

    public Decompressor createDecompressor() {
        return new HadoopLzoDecompressor();
    }

    public String getDefaultExtension() {
        return ".lzo_deflate";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.lzo.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }

    @DoNotPool
    static class HadoopLzoDecompressor
    implements Decompressor {
        HadoopLzoDecompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public boolean needsDictionary() {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public int getRemaining() {
            throw new UnsupportedOperationException("LZO block decompressor is not supported");
        }

        public void reset() {
        }

        public void end() {
        }
    }

    @DoNotPool
    static class HadoopLzoCompressor
    implements Compressor {
        HadoopLzoCompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public long getBytesRead() {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public long getBytesWritten() {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public void finish() {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZO block compressor is not supported");
        }

        public void reset() {
        }

        public void end() {
        }

        public void reinit(Configuration conf) {
        }
    }
}

