/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.mozilla.javascript.commonjs.module.provider;

import com.github.houbie.mozilla.javascript.Context;
import com.github.houbie.mozilla.javascript.Scriptable;
import com.github.houbie.mozilla.javascript.commonjs.module.ModuleScript;
import com.github.houbie.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import java.net.URI;
import java.util.LinkedList;

public class MultiModuleScriptProvider
implements ModuleScriptProvider {
    private final ModuleScriptProvider[] providers;

    public MultiModuleScriptProvider(Iterable<? extends ModuleScriptProvider> providers) {
        LinkedList<ModuleScriptProvider> l = new LinkedList<ModuleScriptProvider>();
        for (ModuleScriptProvider moduleScriptProvider : providers) {
            l.add(moduleScriptProvider);
        }
        this.providers = l.toArray(new ModuleScriptProvider[l.size()]);
    }

    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, URI uri, URI base, Scriptable paths) throws Exception {
        for (ModuleScriptProvider provider : this.providers) {
            ModuleScript script = provider.getModuleScript(cx, moduleId, uri, base, paths);
            if (script == null) continue;
            return script;
        }
        return null;
    }
}

