/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.core.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.houbb.deep.copy.api.IDeepCopy;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.cache.impl.ClassFieldListCache;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.annotation.Sensitive;
import com.github.houbb.sensitive.annotation.metadata.SensitiveCondition;
import com.github.houbb.sensitive.annotation.metadata.SensitiveStrategy;
import com.github.houbb.sensitive.api.ICondition;
import com.github.houbb.sensitive.api.IContext;
import com.github.houbb.sensitive.api.ISensitive;
import com.github.houbb.sensitive.api.ISensitiveConfig;
import com.github.houbb.sensitive.api.IStrategy;
import com.github.houbb.sensitive.api.impl.SensitiveStrategyBuiltIn;
import com.github.houbb.sensitive.core.api.context.SensitiveContext;
import com.github.houbb.sensitive.core.exception.SensitiveRuntimeException;
import com.github.houbb.sensitive.core.support.filter.DefaultContextValueFilter;
import com.github.houbb.sensitive.core.util.entry.SensitiveEntryUtil;
import com.github.houbb.sensitive.core.util.strategy.SensitiveStrategyBuiltInUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ThreadSafe
public class SensitiveService<T>
implements ISensitive<T> {
    public T desCopy(T object, ISensitiveConfig config) {
        Class<?> clazz = object.getClass();
        SensitiveContext context = new SensitiveContext();
        IDeepCopy deepCopy = config.deepCopy();
        Object copyObject = deepCopy.deepCopy(object);
        this.handleClassField(context, copyObject, clazz);
        return (T)copyObject;
    }

    public String desJson(T object, ISensitiveConfig config) {
        if (ObjectUtil.isNull(object)) {
            return JSON.toJSONString(object);
        }
        SensitiveContext context = new SensitiveContext();
        DefaultContextValueFilter filter = new DefaultContextValueFilter(context);
        return JSON.toJSONString(object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
    }

    private void handleClassField(SensitiveContext context, Object copyObject, Class clazz) {
        List fieldList = (List)ClassFieldListCache.getInstance().get((Object)clazz);
        context.setAllFieldList(fieldList);
        context.setCurrentObject(copyObject);
        try {
            for (Field field : fieldList) {
                Class<?> fieldTypeClass = field.getType();
                context.setCurrentField(field);
                if (SensitiveEntryUtil.hasSensitiveEntry(field)) {
                    if (ClassTypeUtil.isJavaBean(fieldTypeClass)) {
                        Object fieldNewObject = field.get(copyObject);
                        this.handleClassField(context, fieldNewObject, fieldTypeClass);
                        continue;
                    }
                    if (ClassTypeUtil.isArray(fieldTypeClass)) {
                        Object[] arrays = (Object[])field.get(copyObject);
                        if (!ArrayUtil.isNotEmpty((Object[])arrays)) continue;
                        Object firstArrayEntry = arrays[0];
                        Class<?> entryFieldClass = firstArrayEntry.getClass();
                        if (this.needHandleEntryType(entryFieldClass)) {
                            for (Object arrayEntry : arrays) {
                                this.handleClassField(context, arrayEntry, entryFieldClass);
                            }
                            continue;
                        }
                        int arrayLength = arrays.length;
                        Object newArray = Array.newInstance(entryFieldClass, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object entry = arrays[i];
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            Array.set(newArray, i, result);
                        }
                        field.set(copyObject, newArray);
                        continue;
                    }
                    if (ClassTypeUtil.isCollection(fieldTypeClass)) {
                        Collection entryCollection = (Collection)field.get(copyObject);
                        if (!CollectionUtil.isNotEmpty((Collection)entryCollection)) continue;
                        Object firstCollectionEntry = entryCollection.iterator().next();
                        Class<?> collectionEntryClass = firstCollectionEntry.getClass();
                        if (this.needHandleEntryType(collectionEntryClass)) {
                            for (Object collectionEntry : entryCollection) {
                                this.handleClassField(context, collectionEntry, collectionEntryClass);
                            }
                            continue;
                        }
                        ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
                        for (Object entry : entryCollection) {
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            newResultList.add(result);
                        }
                        field.set(copyObject, newResultList);
                        continue;
                    }
                    this.handleSensitive(context, copyObject, field);
                    continue;
                }
                this.handleSensitive(context, copyObject, field);
            }
        }
        catch (IllegalAccessException e) {
            throw new SensitiveRuntimeException(e);
        }
    }

    private Object handleSensitiveEntry(SensitiveContext context, Object entry, Field field) {
        try {
            IStrategy strategy;
            Class conditionClass;
            ICondition condition;
            Sensitive sensitive = field.getAnnotation(Sensitive.class);
            if (ObjectUtil.isNotNull((Object)sensitive) && (condition = (ICondition)(conditionClass = sensitive.condition()).newInstance()).valid((IContext)context)) {
                Class strategyClass = sensitive.strategy();
                IStrategy strategy2 = (IStrategy)strategyClass.newInstance();
                return strategy2.des(entry, (IContext)context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayUtil.isNotEmpty((Object[])annotations) && (ObjectUtil.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid((IContext)context)) && ObjectUtil.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                return strategy.des(entry, (IContext)context);
            }
            return entry;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SensitiveRuntimeException(e);
        }
    }

    private void handleSensitive(SensitiveContext context, Object copyObject, Field field) {
        try {
            IStrategy strategy;
            Object[] annotations;
            Class conditionClass;
            ICondition condition;
            Sensitive sensitive = field.getAnnotation(Sensitive.class);
            if (sensitive != null && (condition = (ICondition)(conditionClass = sensitive.condition()).newInstance()).valid((IContext)context)) {
                Class strategyClass = sensitive.strategy();
                IStrategy strategy2 = (IStrategy)strategyClass.newInstance();
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy2.des(originalFieldVal, (IContext)context);
                field.set(copyObject, result);
            }
            if (ArrayUtil.isNotEmpty((Object[])(annotations = field.getAnnotations())) && (ObjectUtil.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid((IContext)context)) && ObjectUtil.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy.des(originalFieldVal, (IContext)context);
                field.set(copyObject, result);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SensitiveRuntimeException(e);
        }
    }

    private IStrategy getStrategy(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            SensitiveStrategy sensitiveStrategy = annotation.annotationType().getAnnotation(SensitiveStrategy.class);
            if (!ObjectUtil.isNotNull((Object)sensitiveStrategy)) continue;
            Class clazz = sensitiveStrategy.value();
            if (SensitiveStrategyBuiltIn.class.equals((Object)clazz)) {
                return SensitiveStrategyBuiltInUtil.require(annotation.annotationType());
            }
            return (IStrategy)ClassUtil.newInstance((Class)clazz);
        }
        return null;
    }

    private ICondition getCondition(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            SensitiveCondition sensitiveCondition = annotation.annotationType().getAnnotation(SensitiveCondition.class);
            if (!ObjectUtil.isNotNull((Object)sensitiveCondition)) continue;
            Class customClass = sensitiveCondition.value();
            return (ICondition)ClassUtil.newInstance((Class)customClass);
        }
        return null;
    }

    private boolean needHandleEntryType(Class fieldTypeClass) {
        if (ClassTypeUtil.isBase((Class)fieldTypeClass) || ClassTypeUtil.isMap((Class)fieldTypeClass)) {
            return false;
        }
        return ClassTypeUtil.isJavaBean((Class)fieldTypeClass) || ClassTypeUtil.isArray((Class)fieldTypeClass) || ClassTypeUtil.isCollection((Class)fieldTypeClass);
    }
}

