/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.rank.core;

import com.github.houbb.rank.api.IRank;
import com.github.houbb.rank.api.RankContext;
import com.github.houbb.rank.constant.RankConst;
import com.github.houbb.rank.core.Ranks;

public class RankNewtonLawOfCooling
implements IRank {
    private final double coolRate;

    public RankNewtonLawOfCooling(double coolRate) {
        this.coolRate = coolRate;
    }

    public RankNewtonLawOfCooling() {
        this(RankConst.COOL_RATE);
    }

    @Override
    public double rank(RankContext context) {
        double currentRank = Ranks.weightAdd().rank(context);
        long currentTime = System.currentTimeMillis();
        double dayMills = RankConst.ONE_DAY_MILLS;
        double dayDiffer = (double)(currentTime - context.unixTime()) / dayMills;
        double expValue = this.coolRate * dayDiffer;
        return currentRank * Math.exp(expValue);
    }
}

