package com.github.houbb.rank.core;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.rank.api.IRank;

/**
 * @author binbin.hou
 * @since 1.0.0
 */
public final class Ranks {

    private Ranks(){}

    /**
     * 添加
     * @return 结果
     */
    public static IRank add() {
        return Instances.singleton(RankAdd.class);
    }

    /**
     * 添加
     * @return 结果
     */
    public static IRank weightAdd() {
        return Instances.singleton(RankWeightAdd.class);
    }

    /**
     * 牛顿冷却算法
     * @return 冷却算法
     * @since 1.0.0
     */
    public static IRank newton() {
        return Instances.singleton(RankNewtonLawOfCooling.class);
    }

    /**
     * 牛顿冷却算法
     *
     * @param coolRate 冷却速率
     * @return 冷却算法
     * @since 1.0.0
     */
    public static IRank newton(double coolRate) {
        return new RankNewtonLawOfCooling(coolRate);
    }

}
