package com.github.houbb.rank.core;

import com.github.houbb.rank.api.IRank;
import com.github.houbb.rank.api.RankContext;
import com.github.houbb.rank.constant.RankConst;

/**
 * 本期得分 = 上一期得分 x exp(-(冷却系数) x 间隔的小时数)
 *
 * @author binbin.hou
 * @since 1.0.0
 */
public class RankNewtonLawOfCooling implements IRank {

    private final double coolRate;

    public RankNewtonLawOfCooling(double coolRate) {
        this.coolRate = coolRate;
    }

    public RankNewtonLawOfCooling() {
        this(RankConst.COOL_RATE);
    }

    @Override
    public double rank(RankContext context) {
        double currentRank = Ranks.weightAdd().rank(context);

        // 计算冷却
        long currentTime = System.currentTimeMillis();
        double dayMills = RankConst.ONE_DAY_MILLS;
        double dayDiffer = (currentTime - context.unixTime()) / dayMills;
        // 间隔的秒
        double expValue = coolRate * (dayDiffer);
        // 可视化一下，折线图
        return currentRank * Math.exp(expValue);
    }

}
