package com.github.houbb.rank.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.rank.api.IRank;
import com.github.houbb.rank.api.RankContext;
import com.github.houbb.rank.core.Ranks;

/**
 * 引导类
 *
 * @author binbin.hou
 * @since 1.0.0
 */
public final class RankBs {

    private RankBs(){}

    public static RankBs newInstance() {
        return new RankBs();
    }

    private IRank rank = Ranks.newton();

    public void rank(IRank rank) {
        ArgUtil.notNull(rank, "rank");

        this.rank = rank;
    }

    /**
     * 执行
     * @param context 上下文
     * @return 结果
     */
    public double execute(final RankContext context) {
        return this.rank.rank(context);
    }

}
