/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.util;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.main.JavaCompiler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavacUtil {
    private static final Pattern VERSION_PARSER = Pattern.compile("^(\\d{1,6})\\.?(\\d{1,6})?.*$");
    private static final Pattern SOURCE_PARSER = Pattern.compile("^JDK(\\d{1,6})_?(\\d{1,6})?.*$");
    private static final AtomicInteger COMPILER_VERSION = new AtomicInteger(-1);

    private JavacUtil() {
    }

    public static int getJavaCompilerVersion() {
        String name;
        Matcher m;
        int cv = COMPILER_VERSION.get();
        if (cv != -1) {
            return cv;
        }
        Matcher m2 = VERSION_PARSER.matcher(JavaCompiler.version());
        if (m2.matches()) {
            int major = Integer.parseInt(m2.group(1));
            if (major == 1) {
                int minor = Integer.parseInt(m2.group(2));
                return JavacUtil.setVersion(minor);
            }
            if (major >= 9) {
                return JavacUtil.setVersion(major);
            }
        }
        if ((m = SOURCE_PARSER.matcher(name = Source.values()[Source.values().length - 1].name())).matches()) {
            int major = Integer.parseInt(m.group(1));
            if (major == 1) {
                int minor = Integer.parseInt(m.group(2));
                return JavacUtil.setVersion(minor);
            }
            if (major >= 9) {
                return JavacUtil.setVersion(major);
            }
        }
        return JavacUtil.setVersion(6);
    }

    private static int setVersion(int version) {
        COMPILER_VERSION.set(version);
        return version;
    }
}

