/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.lombok.ex.annotation.Modifiers;
import com.github.houbb.lombok.ex.processor.BaseProcessor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.Modifiers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ModifiersProcessor
extends BaseProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> modifiersSet = roundEnv.getElementsAnnotatedWith(Modifiers.class);
        for (Element element : modifiersSet) {
            Symbol symbol;
            Modifiers modifiers = element.getAnnotation(Modifiers.class);
            if (element instanceof Symbol.ClassSymbol) {
                symbol = (Symbol.ClassSymbol)element;
                JCTree.JCClassDecl classDecl = this.trees.getTree((TypeElement)((Object)symbol));
                this.updateModifiers(classDecl.mods, modifiers);
                continue;
            }
            if (element instanceof Symbol.MethodSymbol) {
                symbol = (Symbol.MethodSymbol)element;
                JCTree.JCMethodDecl methodDecl = this.trees.getTree((ExecutableElement)((Object)symbol));
                this.updateModifiers(methodDecl.mods, modifiers);
                continue;
            }
            if (!element.getKind().isField()) continue;
            JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)this.trees.getTree(element);
            this.updateModifiers(variableDecl.mods, modifiers);
        }
        return true;
    }

    private void updateModifiers(JCTree.JCModifiers jcModifiers, Modifiers modifiers) {
        long oldValue = jcModifiers.flags;
        long newValue = modifiers.value();
        boolean isAppendMode = modifiers.appendMode();
        if (isAppendMode) {
            newValue = oldValue | newValue;
        }
        jcModifiers.flags = newValue;
    }
}

