/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.alibaba.fastjson.JSON;
import com.github.houbb.lombok.ex.annotation.ToString;
import com.github.houbb.lombok.ex.constant.ToStringType;
import com.github.houbb.lombok.ex.metadata.LClass;
import com.github.houbb.lombok.ex.processor.BaseClassProcessor;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.ToString"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ToStringProcessor
extends BaseClassProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return ToString.class;
    }

    @Override
    protected void handleClass(LClass lClass) {
        if (!lClass.containsMethod("toString")) {
            this.generateToStringMethod(lClass);
        }
    }

    private void generateToStringMethod(LClass lClass) {
        ListBuffer<JCTree> defBufferList = new ListBuffer<JCTree>();
        List<JCTree> defList = lClass.classDecl().defs;
        defBufferList.addAll((Collection<JCTree>)defList);
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(1L);
        Name name = this.names.fromString("toString");
        List<JCTree.JCStatement> statements = this.createToStringStatements(lClass);
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, statements);
        JCTree.JCIdent restype = this.treeMaker.Ident(this.names.fromString("String"));
        JCTree.JCMethodDecl methodDecl = this.treeMaker.MethodDef(modifiers, name, restype, List.nil(), List.nil(), List.nil(), jcBlock, null);
        defBufferList.add(methodDecl);
        lClass.classDecl().defs = defBufferList.toList();
    }

    private List<JCTree.JCStatement> createToStringStatements(LClass lClass) {
        ToString toString = lClass.classSymbol().getAnnotation(ToString.class);
        ToStringType type = toString.value();
        if (ToStringType.FAST_JSON.equals((Object)type)) {
            return this.createFastJsonStatements(lClass);
        }
        return this.createStringConcatStatements(lClass);
    }

    private List<JCTree.JCStatement> createFastJsonStatements(LClass lClass) {
        lClass.importPackage(lClass, JSON.class);
        JCTree.JCFieldAccess fieldAccess = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString("JSON")), this.names.fromString("toJSONString"));
        ListBuffer<JCTree.JCIdent> identBuffers = new ListBuffer<JCTree.JCIdent>();
        identBuffers.add(this.treeMaker.Ident(this.names.fromString("this")));
        JCTree.JCMethodInvocation methodInvocation = this.treeMaker.Apply(List.nil(), fieldAccess, identBuffers.toList());
        JCTree.JCReturn statement = this.treeMaker.Return(methodInvocation);
        return List.of(statement);
    }

    private List<JCTree.JCStatement> createStringConcatStatements(LClass lClass) {
        String fullClassName = lClass.classSymbol().fullname.toString();
        String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        JCTree.JCLiteral start = this.treeMaker.Literal(className + "{");
        JCTree.JCBinary lhs = null;
        JCTree.Tag tag = JCTree.Tag.PLUS;
        for (JCTree jcTree : lClass.classDecl().defs) {
            JCTree.JCLiteral fieldName;
            if (jcTree.getKind() != Tree.Kind.VARIABLE) continue;
            JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)jcTree;
            String varName = variableDecl.name.toString();
            if (lhs == null) {
                fieldName = this.treeMaker.Literal(varName + "=");
                lhs = this.treeMaker.Binary(tag, start, fieldName);
            } else {
                fieldName = this.treeMaker.Literal(", " + varName + "=");
                lhs = this.treeMaker.Binary(tag, lhs, fieldName);
            }
            String typeName = variableDecl.vartype.toString();
            if (typeName.endsWith("[]")) {
                JCTree.JCMethodInvocation methodInvocation = this.buildArraysToString(lClass, varName);
                lhs = this.treeMaker.Binary(tag, lhs, methodInvocation);
                continue;
            }
            JCTree.JCIdent fieldValue = this.treeMaker.Ident(this.names.fromString(varName));
            lhs = this.treeMaker.Binary(tag, lhs, fieldValue);
        }
        JCTree.JCLiteral rhs = this.treeMaker.Literal("}");
        JCTree.JCBinary binary = this.treeMaker.Binary(tag, lhs, rhs);
        JCTree.JCReturn statement = this.treeMaker.Return(binary);
        return List.of(statement);
    }

    private JCTree.JCMethodInvocation buildArraysToString(LClass lClass, String varName) {
        lClass.importPackage(lClass, Arrays.class);
        JCTree.JCFieldAccess fieldAccess = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString("Arrays")), this.names.fromString("toString"));
        ListBuffer<JCTree.JCIdent> identBuffers = new ListBuffer<JCTree.JCIdent>();
        identBuffers.add(this.treeMaker.Ident(this.names.fromString(varName)));
        return this.treeMaker.Apply(List.nil(), fieldAccess, identBuffers.toList());
    }
}

