/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.lombok.ex.annotation.Serial;
import com.github.houbb.lombok.ex.metadata.LClass;
import com.github.houbb.lombok.ex.metadata.LField;
import com.github.houbb.lombok.ex.metadata.LObject;
import com.github.houbb.lombok.ex.processor.BaseClassProcessor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.Serial"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class SerialProcessor
extends BaseClassProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return Serial.class;
    }

    @Override
    protected void handleClass(LClass lClass) {
        lClass.addInterface(Serializable.class);
        this.createSerialVersionUID(lClass);
    }

    private void createSerialVersionUID(LClass lClass) {
        Serial serial = lClass.classSymbol().getAnnotation(Serial.class);
        LObject value = new LObject(this.processContext).expression(this.treeMaker.Literal(serial.value()));
        LField lField = LField.newInstance().modifiers(26L).type(Long.class).name("serialVersionUID").value(value);
        lClass.insertField(lField);
    }
}

