/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.auto.log.annotation.AutoLog;
import com.github.houbb.lombok.ex.metadata.LMethod;
import com.github.houbb.lombok.ex.processor.BaseMethodProcessor;
import com.github.houbb.lombok.ex.support.log.impl.ConsoleLog;
import com.github.houbb.lombok.ex.util.AstUtil;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;

@SupportedAnnotationTypes(value={"com.github.houbb.auto.log.annotation.AutoLog"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class AutoLogProcessor
extends BaseMethodProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return AutoLog.class;
    }

    @Override
    protected void handleMethod(LMethod method) {
        Symbol.MethodSymbol element = method.methodSymbol();
        String fullClassName = ConsoleLog.class.getName();
        AstUtil.importPackage(this.processContext, element, fullClassName);
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String fieldName = "LOMBOK_EX_LOG";
        List<JCTree.JCLiteral> args = List.of(this.treeMaker.Literal(AstUtil.getPackageName(this.processContext, element)));
        AstUtil.defineVariable(this.processContext, method.methodSymbol(), className, "LOMBOK_EX_LOG", List.nil());
        this.generateBlockCode(fullClassName, element, "LOMBOK_EX_LOG");
    }

    private void generateBlockCode(final String fullClassName, final Element element, final String varName) {
        final TreeMaker treeMaker = this.processContext.treeMaker();
        final Names names = this.processContext.names();
        JavacTrees trees = this.processContext.trees();
        JCTree tree = (JCTree)((Trees)trees).getTree(element);
        tree.accept(new TreeTranslator(){

            @Override
            public void visitBlock(JCTree.JCBlock tree) {
                ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
                JCTree.JCFieldAccess fieldAccess = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names.fromString(varName)), names.fromString("logParam"));
                JCTree.JCLiteral methodName = AstUtil.getMethodName(AutoLogProcessor.this.processContext, element);
                List<JCTree.JCExpression> args = AstUtil.getParameters(AutoLogProcessor.this.processContext, element);
                JCTree.JCLiteral fullClassNameActual = treeMaker.Literal(fullClassName);
                List<JCTree.JCExpression> params = List.of(fullClassNameActual, methodName);
                for (JCTree.JCExpression arg : args) {
                    params = params.append((JCTree.JCLiteral)arg);
                }
                JCTree.JCMethodInvocation methodInvocation = treeMaker.Apply(List.nil(), fieldAccess, params);
                JCTree.JCExpressionStatement code = treeMaker.Exec(methodInvocation);
                statements.append(code);
                for (int i = 0; i < ((List)tree.getStatements()).size(); ++i) {
                    JCTree.JCStatement statement = (JCTree.JCStatement)((List)tree.getStatements()).get(i);
                    statements.append(statement);
                }
                this.result = treeMaker.Block(0L, statements.toList());
            }
        });
    }
}

