/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.alibaba.fastjson.JSON;
import com.github.houbb.lombok.ex.annotation.ToString;
import com.github.houbb.lombok.ex.metadata.LClass;
import com.github.houbb.lombok.ex.processor.BaseClassProcessor;
import com.github.houbb.lombok.ex.support.tostring.impl.ToStringFastJson;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.ToString"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ToStringProcessor
extends BaseClassProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return ToString.class;
    }

    @Override
    protected void handleClass(LClass lClass) {
        lClass.importPackage(lClass, JSON.class);
        lClass.importPackage(lClass, ToStringFastJson.class);
        if (!lClass.containsMethod("toString")) {
            this.generateToStringMethod(lClass);
        }
    }

    private void generateToStringMethod(LClass lClass) {
        ListBuffer<JCTree> defBufferList = new ListBuffer<JCTree>();
        List<JCTree> defList = lClass.classDecl().defs;
        defBufferList.addAll((Collection<JCTree>)defList);
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(1L);
        Name name = this.names.fromString("toString");
        List<JCTree.JCStatement> statements = List.of(this.createJSONString());
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, statements);
        JCTree.JCIdent restype = this.treeMaker.Ident(this.names.fromString("String"));
        JCTree.JCMethodDecl methodDecl = this.treeMaker.MethodDef(modifiers, name, restype, List.nil(), List.nil(), List.nil(), jcBlock, null);
        defBufferList.add(methodDecl);
        lClass.classDecl().defs = defBufferList.toList();
    }

    private JCTree.JCStatement createJSONString() {
        JCTree.JCFieldAccess fieldAccess = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString("JSON")), this.names.fromString("toJSONString"));
        ListBuffer<JCTree.JCIdent> identBuffers = new ListBuffer<JCTree.JCIdent>();
        identBuffers.add(this.treeMaker.Ident(this.names.fromString("this")));
        JCTree.JCMethodInvocation methodInvocation = this.treeMaker.Apply(List.nil(), fieldAccess, identBuffers.toList());
        return this.treeMaker.Return(methodInvocation);
    }
}

