/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.util;

import com.github.houbb.lombok.ex.model.ProcessContext;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.Element;

public final class AstUtil {
    private AstUtil() {
    }

    public static String getPackageName(ProcessContext context, Element element) {
        JavacTrees trees = context.trees();
        return ((JCTree.JCClassDecl)((Trees)trees).getTree((Element)element.getEnclosingElement())).sym.toString();
    }

    public static JCTree.JCLiteral getMethodName(final ProcessContext context, Element element) {
        final JCTree.JCLiteral[] methodName = new JCTree.JCLiteral[]{null};
        JCTree tree = context.trees().getTree(element);
        tree.accept(new TreeTranslator(){

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
                if (methodName[0] == null) {
                    methodName[0] = context.treeMaker().Literal(jcMethodDecl.getName().toString());
                }
                super.visitMethodDef(jcMethodDecl);
            }
        });
        return methodName[0];
    }

    public static List<JCTree.JCExpression> getParameters(final ProcessContext context, Element element) {
        final List[] params = new List[]{List.nil()};
        JCTree tree = context.trees().getTree(element);
        tree.accept(new TreeTranslator(){

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
                for (JCTree.JCVariableDecl decl : jcMethodDecl.getParameters()) {
                    params[0] = params[0].append(context.treeMaker().Ident(decl));
                }
                super.visitMethodDef(jcMethodDecl);
            }
        });
        return params[0];
    }

    public static void importPackage(ProcessContext context, Element element, String fullClassName) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)context.trees().getPath(element.getEnclosingElement()).getCompilationUnit();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String packageName = fullClassName.substring(0, fullClassName.lastIndexOf("."));
        TreeMaker treeMaker = context.treeMaker();
        Names names = context.names();
        JCTree.JCFieldAccess fieldAccess = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names.fromString(packageName)), names.fromString(className));
        JCTree.JCImport jcImport = treeMaker.Import(fieldAccess, false);
        ListBuffer<JCTree> imports = new ListBuffer<JCTree>();
        imports.append(jcImport);
        for (int i = 0; i < compilationUnit.defs.size(); ++i) {
            imports.append(compilationUnit.defs.get(i));
        }
        compilationUnit.defs = imports.toList();
    }

    public static void defineVariable(ProcessContext context, Element element, final String className, final String varName, final List<JCTree.JCExpression> args) {
        final TreeMaker treeMaker = context.treeMaker();
        final Names names = context.names();
        JavacTrees trees = context.trees();
        JCTree tree = (JCTree)((Trees)trees).getTree(element.getEnclosingElement());
        tree.accept(new TreeTranslator(){

            @Override
            public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
                boolean hasVariable = AstUtil.hasVariable(this.translate(jcClassDecl.defs), className, varName);
                ListBuffer<JCTree> statements = new ListBuffer<JCTree>();
                for (JCTree jcTree : jcClassDecl.defs) {
                    statements.append(jcTree);
                }
                if (!hasVariable) {
                    JCTree.JCIdent typeExpr = treeMaker.Ident(names.fromString(className));
                    JCTree.JCNewClass newClassExpr = treeMaker.NewClass(null, List.nil(), typeExpr, args, null);
                    int modifiers = 2;
                    if (jcClassDecl.sym != null) {
                        if (jcClassDecl.sym.flatname.toString().equals(jcClassDecl.sym.fullname.toString())) {
                            modifiers |= 8;
                        }
                        JCTree.JCVariableDecl variableDecl = treeMaker.VarDef(treeMaker.Modifiers(modifiers), names.fromString(varName), typeExpr, newClassExpr);
                        statements.append(variableDecl);
                        jcClassDecl.defs = statements.toList();
                    }
                }
                super.visitClassDef(jcClassDecl);
            }
        });
    }

    private static boolean hasVariable(List<JCTree> oldList, String className, String varName) {
        boolean hasField = false;
        for (JCTree jcTree : oldList) {
            if (jcTree.getKind() != Tree.Kind.VARIABLE) continue;
            JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)jcTree;
            if (!varName.equals(variableDecl.name.toString()) || !className.equals(variableDecl.vartype.toString())) continue;
            hasField = true;
            break;
        }
        return hasField;
    }
}

