/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class PropertyDescriptorUtil {
    private PropertyDescriptorUtil() {
    }

    public static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        ArgUtil.notNull(beanClass, "beanClass");
        ArgUtil.notEmpty(propertyName, "propertyName");
        try {
            return new PropertyDescriptor(propertyName, beanClass);
        }
        catch (IntrospectionException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Method getReadMethod(Class beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getReadMethod();
    }

    public static Method getWriteMethod(Class beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getWriteMethod();
    }

    public static Class<?> getPropertyType(Class beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getPropertyType();
    }

    public static List<PropertyDescriptor> getAllPropertyDescriptorList(final Class beanClass) {
        ArgUtil.notNull(beanClass, "beanClass");
        List<Field> fieldList = ClassUtil.getAllFieldList(beanClass);
        return CollectionUtil.toList(fieldList, new IHandler<Field, PropertyDescriptor>(){

            @Override
            public PropertyDescriptor handle(Field field) {
                String fieldName = field.getName();
                return PropertyDescriptorUtil.getPropertyDescriptor(beanClass, fieldName);
            }
        });
    }
}

