/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.lang.StringUtil;

public final class CharUtil {
    private CharUtil() {
    }

    public static boolean isEmpty(Character character) {
        return character == null;
    }

    public static boolean isNotEmpty(Character character) {
        return !CharUtil.isEmpty(character);
    }

    public static String repeat(char unit, int times) {
        String component = String.valueOf(unit);
        return StringUtil.repeat(component, times);
    }

    public static char toHalfWidth(char c) {
        char resultChar = c;
        if (resultChar == '\u3000') {
            resultChar = ' ';
        } else if (resultChar > '\uff00' && resultChar < '\uff5f') {
            resultChar = (char)(resultChar - 65248);
        }
        return resultChar;
    }

    public static char toFullWidth(char c) {
        char resultChar = c;
        if (resultChar == ' ') {
            resultChar = '\u3000';
        } else if (resultChar >= '!' && resultChar <= '~') {
            resultChar = (char)(resultChar + 65248);
        }
        return resultChar;
    }

    public static boolean isChinesePunctuation(char c) {
        Character.UnicodeScript sc = Character.UnicodeScript.of(c);
        return sc == Character.UnicodeScript.HAN;
    }

    public static boolean isSpace(char c) {
        return Character.isSpaceChar(c) || '\u0013' == c;
    }

    public static boolean isDigitOrLetter(char c) {
        return Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    public static boolean isEmilChar(char c) {
        return CharUtil.isDigitOrLetter(c) || '_' == c || '-' == c || c == '.' || c == '@';
    }

    public static boolean isWebSiteChar(char c) {
        return CharUtil.isDigitOrLetter(c) || '-' == c || '.' == c;
    }
}

