/*
 * Copyright (c)  2019. houbinbin Inc.
 * heaven All rights reserved.
 */

package com.github.houbb.heaven.constant;

/**
 * 标点符号常量
 *
 * @author bbhou
 * @since 0.0.1
 */
public final class PunctuationConst {

    private PunctuationConst(){}



    /**
     * 逗号
     */
    public static final String COMMA = ",";

    /**
     * 冒号
     */
    public static final String COLON = ":";

    /**
     * 圆点
     */
    public static final String DOT = ".";

    /**
     * 空格
     */
    public static final String BLANK = " ";

    /**
     * 单引号
     */
    public static final String SINGLE_QUOTES = "'";

    /**
     * 下划线
     */
    public static final String UNDERLINE = "_";

    /**
     * at 符号
     */
    public static final String AT = "@";

    /**
     * 斜杠
     */
    public static final String SLASH = "/";

    /**
     * 星
     * @since 0.0.8
     */
    public static final String STAR = "*";

    /**
     * 双引号
     * @since 0.0.8
     */
    public static final String DOUBLE_QUOTES = "\"";

    /**
     * 空
     * @since 0.0.8
     */
    public static final String EMPTY = "";

    /**
     * 非
     * @since 0.0.8
     */
    public static final String NOT = "!";

    /**
     * 与
     * @since 0.0.8
     */
    public static final String AND = "&";

    /**
     * 或
     * @since 0.0.8
     */
    public static final String OR = "|";

    /**
     * #
     * @since 0.0.8
     */
    public static final String SHAPE = "#";

    /**
     * 美元
     * @since 0.0.8
     */
    public static final String DOLLAR = "$";

    /**
     * 百分比
     * @since 0.0.8
     */
    public static final String PERCENT = "%";

    /**
     * 幂
     * @since 0.0.8
     */
    public static final String CARET = "^";

    /**
     * 中划线
     * @since 0.0.8
     */
    public static final String MIDDLE_LINE = "-";

    /**
     * 等于号
     * @since 0.1.17
     */
    public static final String EQUAL = "=";

    /**
     * 问号
     * @since 0.1.9
     */
    public static final String QUESTION_MARK = "?";

}
