/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MapUtil {
    private MapUtil() {
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || 0 == map.size();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.EMPTY_MAP;
        }
        return MapUtil.toMap(values.iterator(), keyFunction);
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        while (values.hasNext()) {
            V value = values.next();
            K key = keyFunction.handle(value);
            map.put(key, value);
        }
        return map;
    }
}

