/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.hash.core.util;

import com.github.houbb.hash.api.IHash;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.hash.core.bs.HashBs;
import com.github.houbb.hash.core.core.handler.HashResultHandlers;
import com.github.houbb.hash.core.core.hash.Hashes;
import com.github.houbb.heaven.util.codec.CodecSupport;

public final class HashHelper {
    private HashHelper() {
    }

    public static String hash(String text) {
        return HashHelper.hash(Hashes.md5(), text);
    }

    public static String hash(IHash hash, String text) {
        return HashHelper.hash(hash, text, HashResultHandlers.hex());
    }

    public static <T> T hash(IHash hash, String text, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(hash, text, null, hashResultHandler);
    }

    public static <T> T hash(IHash hash, String text, String salt, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(hash, text, salt, 1, hashResultHandler);
    }

    public static <T> T hash(IHash hash, String text, String salt, int times, IHashResultHandler<T> hashResultHandler) {
        return HashBs.newInstance().hash(hash).salt(CodecSupport.toBytes((String)salt)).times(times).execute(CodecSupport.toBytes((String)text), hashResultHandler);
    }
}

