/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.data.struct.core.util.list;

import com.github.houbb.data.struct.core.util.list.Node;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LinkedList<E>
implements List<E> {
    private int size;
    private Node<E> head;
    private Node<E> tail;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) > -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (CollectionUtil.isEmpty(c)) {
            return false;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        Node<E> originalTail = this.tail;
        Node<E> newNode = new Node<E>(e, originalTail, null);
        this.tail = newNode;
        if (originalTail == null) {
            this.head = newNode;
        } else {
            originalTail.next(newNode);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (ObjectUtil.isNull(this.head)) {
            return false;
        }
        for (Node<E> node = this.head; node != null; node = node.next()) {
            E value = node.value();
            if (!ObjectUtil.isEqualsOrNull((Object)o, value)) continue;
            Node<E> previous = node.previous();
            Node<E> next = node.next();
            if (ObjectUtil.isNull(previous)) {
                this.head = next;
                this.head.previous(null);
            }
            if (ObjectUtil.isNull(next)) {
                this.tail = previous;
                this.tail.next(null);
            }
            if (ObjectUtil.isNotNull(previous) && ObjectUtil.isNotNull(next)) {
                previous.next(next);
                next.previous(previous);
            }
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        return null;
    }

    @Override
    public E set(int index, E element) {
        return null;
    }

    @Override
    public void add(int index, E element) {
    }

    @Override
    public E remove(int index) {
        Node<E> node = this.head;
        for (int i = 0; i < index; ++i) {
            node = node.next();
        }
        E elem = node.value();
        return elem;
    }

    @Override
    public int indexOf(Object o) {
        if (ObjectUtil.isNull(this.head)) {
            return -1;
        }
        int i = 0;
        for (Node<E> node = this.head; node != null; node = node.next()) {
            E value = node.value();
            if (ObjectUtil.isEqualsOrNull(value, (Object)o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (ObjectUtil.isNull(this.tail)) {
            return -1;
        }
        int i = this.size - 1;
        for (Node<E> node = this.tail; node != null; node = node.previous()) {
            E value = node.value();
            if (ObjectUtil.isEqualsOrNull(value, (Object)o)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return null;
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }
}

