/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.data.struct.core.util.list;

import com.github.houbb.data.struct.core.util.list.Lists;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayList<E>
implements List<E>,
Serializable {
    private transient Object[] array;
    private int size = 0;

    public ArrayList() {
        this(8);
    }

    public ArrayList(int capacity) {
        this.array = new Object[capacity];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean add(E e) {
        this.add(this.size, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (CollectionUtil.isEmpty(c)) {
            return false;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.indexRangeCheck(index);
        if (CollectionUtil.isEmpty(c)) {
            return false;
        }
        this.ensureIncrease(this.size + c.size());
        int afterIndexArraySize = this.size - 1 - index;
        Object[] afterIndexArray = new Object[]{};
        if (afterIndexArraySize > 0) {
            afterIndexArray = new Object[afterIndexArraySize];
            System.arraycopy(this.array, index, afterIndexArray, 0, afterIndexArraySize);
        }
        int setStartIndex = index;
        for (E elem : c) {
            this.array[setStartIndex] = elem;
            ++setStartIndex;
        }
        if (afterIndexArraySize > 0) {
            System.arraycopy(afterIndexArray, 0, this.array, setStartIndex, afterIndexArraySize);
        }
        this.size += c.size();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchVenn(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchVenn(c, true);
    }

    private boolean batchVenn(Collection<?> c, boolean containsFlag) {
        if (containsFlag && CollectionUtil.isEmpty(c)) {
            this.array = Lists.EMPTY_ARRAY;
            this.size = 0;
            return true;
        }
        if (!containsFlag && CollectionUtil.isEmpty(c)) {
            return false;
        }
        Object[] newArray = new Object[this.size];
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            E elem = this.get(i);
            if (c.contains(elem) != containsFlag) continue;
            newArray[newSize++] = elem;
        }
        boolean modified = false;
        if (this.size != newSize) {
            modified = true;
        }
        if (modified) {
            this.array = newArray;
            this.size = newSize;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.array = null;
    }

    @Override
    public E get(int index) {
        return (E)this.array[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.get(index);
        this.array[index] = element;
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        this.addAll(index, Collections.singletonList(element));
    }

    @Override
    public E remove(int index) {
        E elem = this.get(index);
        int movedLength = this.size - 1 - index;
        if (movedLength > 0) {
            System.arraycopy(this.array, index + 1, this.array, index, movedLength);
        }
        this.array[this.size--] = null;
        return elem;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!ObjectUtil.isEqualsOrNull((Object)o, (Object)this.array[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!ObjectUtil.isEqualsOrNull((Object)o, (Object)this.array[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayListIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ArrayListListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ArrayListListIterator(index);
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (ObjectUtil.isNull(a) || a.length < this.size) {
            return Arrays.copyOf(this.array, this.size, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        if (a.length > this.size) {
            for (int i = this.size; i < a.length; ++i) {
                a[i] = null;
            }
        }
        return a;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        if (size <= 0) {
            return Collections.emptyList();
        }
        ArrayList<E> newList = new ArrayList<E>(size);
        for (int i = fromIndex; i <= toIndex; ++i) {
            newList.add(this.get(i));
        }
        return newList;
    }

    private void ensureIncrease(int minSize) {
        if (this.array.length < minSize) {
            this.array = Arrays.copyOf(this.array, minSize * 2);
        }
    }

    private void ensureDecrease(int maxSize) {
    }

    private void indexRangeCheck(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index out of range: " + index + ", it must be in [0, " + this.size + "]");
        }
    }

    private class ArrayListListIterator
    extends ArrayListIterator
    implements ListIterator<E> {
        public ArrayListListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            return ArrayList.this.get(--this.cursor);
        }

        @Override
        public void set(E e) {
            int lastReturn = this.cursor - 1;
            ArrayList.this.set(lastReturn, e);
        }

        @Override
        public void add(E e) {
            ArrayList.this.add(this.cursor, e);
            ++this.cursor;
        }
    }

    private class ArrayListIterator
    implements Iterator<E> {
        protected int cursor;

        private ArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ArrayList.this.size;
        }

        @Override
        public E next() {
            Object result = ArrayList.this.get(this.cursor);
            ++this.cursor;
            return result;
        }

        @Override
        public void remove() {
            ArrayList.this.remove(this.cursor);
        }
    }
}

