/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.api.ICompressResult;
import com.github.houbb.compress.api.IUncompressResult;
import com.github.houbb.compress.bs.CompressBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.support.result.compress.impl.CompressResultHandlers;
import com.github.houbb.compress.support.result.uncompress.impl.UncompressResultHandlers;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.FileUtil;
import java.io.FileInputStream;
import java.io.IOException;

public final class CompressHelper {
    private CompressHelper() {
    }

    public static ICompressResult compress(String source) {
        String target = FileUtil.getDirPath((String)source) + FileUtil.getFileName((String)source) + "." + CompressTypeEnum.ZIP.fileSuffix();
        return CompressHelper.compress(CompressTypeEnum.ZIP, source, target);
    }

    public static ICompressResult compress(String source, String target) {
        String fileSuffix = FileUtil.getSuffix((String)target);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        return CompressHelper.compress(compressTypeEnum, source, target);
    }

    public static ICompressResult compress(CompressTypeEnum compressTypeEnum, String source, String target) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)target, (String)"target");
        return CompressBs.newInstance(compressTypeEnum).compressSources(source).target(target).compress(CompressResultHandlers.defaults());
    }

    public static IUncompressResult uncompress(String source) {
        String targetDir = FileUtil.getDirPath((String)source);
        return CompressHelper.uncompress(source, targetDir);
    }

    public static IUncompressResult uncompress(String source, String targetDir) {
        String fileSuffix = FileUtil.getSuffix((String)source);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        return CompressHelper.uncompress(compressTypeEnum, source, targetDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IUncompressResult uncompress(CompressTypeEnum compressTypeEnum, String source, String targetDir) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)targetDir, (String)"target");
        try (FileInputStream inputStream = new FileInputStream(source);){
            IUncompressResult iUncompressResult = CompressBs.newInstance(compressTypeEnum).uncompressStream(inputStream).target(targetDir).uncompress(UncompressResultHandlers.defaults());
            return iUncompressResult;
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }
}

