/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.archive;

import com.github.houbb.compress.api.ICompressContext;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.handler.adaptor.UnArchiveHandlerAdaptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;

abstract class AbstractUnArchiveHandler
extends UnArchiveHandlerAdaptor {
    AbstractUnArchiveHandler() {
    }

    protected abstract ArchiveInputStream getArchiveInputStream(File var1, String var2);

    protected int getEntrySize(ArchiveEntry entry) {
        return (int)entry.getSize();
    }

    @Override
    public void handle(ICompressContext context) {
        this.doHandler(context);
    }

    protected void doHandler(ICompressContext context) {
        File sourceFile = context.sourcePathFirst().toFile();
        File targetDir = context.targetPath().toFile();
        String password = context.password();
        try (ArchiveInputStream inputStream = this.getArchiveInputStream(sourceFile, password);){
            ArchiveEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    File dir = this.buildFile(targetDir, entry);
                    dir.mkdirs();
                    entry = inputStream.getNextEntry();
                    continue;
                }
                File file = this.buildFile(targetDir, entry);
                file.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(file);){
                    int entrySize = this.getEntrySize(entry);
                    byte[] content = new byte[entrySize];
                    inputStream.read(content, 0, content.length);
                    out.write(content);
                }
                entry = inputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }

    private File buildFile(File targetDir, ArchiveEntry entry) {
        return new File(targetDir.getPath() + File.separator + entry.getName());
    }
}

