/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.core;

import com.github.houbb.compress.context.ICompressContext;
import com.github.houbb.compress.handler.ICompressHandler;
import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.heaven.support.instance.impl.InstanceFactory;

@NotThreadSafe
public class CompressBootstrap {
    private ICompressHandler compressHandler;
    private ICompressContext compressContext;

    private CompressBootstrap() {
    }

    public static CompressBootstrap handler(Class<? extends ICompressHandler> handlerClass) {
        CompressBootstrap compressBootstrap = new CompressBootstrap();
        compressBootstrap.setHandler(handlerClass);
        return compressBootstrap;
    }

    public CompressBootstrap context(ICompressContext compressContext) {
        this.compressContext = compressContext;
        return this;
    }

    public void compress() {
        this.compressHandler.handle(this.compressContext);
    }

    private void setHandler(Class<? extends ICompressHandler> handlerClass) {
        this.compressHandler = (ICompressHandler)InstanceFactory.getInstance().singleton(handlerClass);
    }
}

