/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.annotation.CommonEager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

@CommonEager
public class CompressFileUtil {
    public static void makeDir(File dir) {
        if (dir.isDirectory()) {
            if (dir.exists()) {
                return;
            }
            boolean mkResult = dir.mkdirs();
            if (!mkResult) {
                throw new RuntimeException("Mark dir fail for file: " + dir);
            }
        } else {
            File parentDir = dir.getParentFile();
            if (parentDir.exists()) {
                return;
            }
            boolean mkResult = dir.mkdirs();
            if (!mkResult) {
                throw new RuntimeException("Mark dir fail for file: " + dir);
            }
        }
    }

    public static List<Path> getPathList(Path rootPath) {
        final ArrayList<Path> pathList = new ArrayList<Path>();
        try {
            if (Files.isDirectory(rootPath, new LinkOption[0])) {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        pathList.add(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        pathList.add(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                pathList.add(rootPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pathList;
    }
}

