/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotchpotch.iconicfontengine;

import android.graphics.Typeface;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.github.hotchpotch.iconicfontengine.IconicFontMap;
import com.github.hotchpotch.iconicfontengine.IconicFontTypefaceSpan;
import java.util.ArrayList;

public class IconicFontEngine {
    public static final String TAG = IconicFontEngine.class.getSimpleName();
    private static ArrayList<IconicFontEngine> defaultEngines = new ArrayList();
    private Typeface typeface;
    private IconicFontMap iconicFontMap;

    public static ArrayList<IconicFontEngine> getDefaultEngines() {
        return defaultEngines;
    }

    public static void addDefaultEngine(IconicFontEngine engine) {
        defaultEngines.add(engine);
    }

    public static CharSequence apply(CharSequence charSequence) {
        return IconicFontEngine.apply(charSequence, IconicFontEngine.getDefaultEngines());
    }

    public static CharSequence apply(CharSequence charSequence, ArrayList<IconicFontEngine> engines) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return "";
        }
        return IconicFontEngine.render(new SpannableStringBuilder(charSequence), engines);
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public IconicFontMap getIconicFontMap() {
        return this.iconicFontMap;
    }

    public IconicFontEngine(Typeface typeface, IconicFontMap iconicFontMap) {
        this.typeface = typeface;
        this.iconicFontMap = iconicFontMap;
    }

    private static CharSequence render(SpannableStringBuilder spannableStringBuilder, ArrayList<IconicFontEngine> engines) {
        int caret = 0;
        ArrayList<Pair> positions = new ArrayList<Pair>();
        while (true) {
            StringBuilder text = new StringBuilder(spannableStringBuilder.toString());
            int startBracketIndex = text.indexOf("{", caret);
            int endBracketIndex = text.indexOf("}", startBracketIndex + 1);
            if (startBracketIndex == -1 || endBracketIndex == -1) break;
            String iconString = text.substring(startBracketIndex + 1, endBracketIndex);
            boolean found = false;
            for (IconicFontEngine engine : engines) {
                Character fontChar = engine.getIconicFontMap().get(iconString);
                if (fontChar == null) continue;
                spannableStringBuilder.replace(startBracketIndex, endBracketIndex + 1, (CharSequence)String.valueOf(fontChar));
                positions.add(new Pair((Object)startBracketIndex, (Object)engine));
                caret = startBracketIndex + 1;
                found = true;
                break;
            }
            if (found) continue;
            Log.w((String)TAG, (String)("{" + iconString + "} not fount in fontMaps"));
            caret = endBracketIndex + 1;
        }
        for (Pair pair : positions) {
            IconicFontEngine.setSpan(((IconicFontEngine)pair.second).getTypeface(), spannableStringBuilder, (Integer)pair.first);
        }
        return spannableStringBuilder;
    }

    private static void setSpan(Typeface typeface, SpannableStringBuilder builder, int startIndex) {
        builder.setSpan((Object)new IconicFontTypefaceSpan(typeface), startIndex, startIndex + 1, 34);
    }
}

