/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher.processor.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import permissions.dispatcher.processor.PermissionsProcessorKt;
import permissions.dispatcher.processor.ProcessorUnit;
import permissions.dispatcher.processor.RuntimePermissionsElement;
import permissions.dispatcher.processor.exception.DuplicatedMethodNameException;
import permissions.dispatcher.processor.exception.DuplicatedValueException;
import permissions.dispatcher.processor.exception.MixPermissionTypeException;
import permissions.dispatcher.processor.exception.NoAnnotatedMethodsException;
import permissions.dispatcher.processor.exception.NoParametersAllowedException;
import permissions.dispatcher.processor.exception.NoThrowsAllowedException;
import permissions.dispatcher.processor.exception.PrivateMethodException;
import permissions.dispatcher.processor.exception.WrongClassException;
import permissions.dispatcher.processor.exception.WrongParametersException;
import permissions.dispatcher.processor.exception.WrongReturnTypeException;
import permissions.dispatcher.processor.util.ExtensionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a,\u0010\b\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a5\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a,\u0010\u0015\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a4\u0010\u0016\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a,\u0010\u0019\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u00062\u0006\u0010\u001e\u001a\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"SYSTEM_ALERT_WINDOW", "", "WRITE_SETTINGS", "checkDuplicatedMethodName", "", "items", "", "Ljavax/lang/model/element/ExecutableElement;", "checkDuplicatedValue", "A", "", "annotationClass", "Ljava/lang/Class;", "checkMethodParameters", "numParams", "", "requiredTypes", "", "Ljavax/lang/model/type/TypeMirror;", "(Ljava/util/List;I[Ljavax/lang/model/type/TypeMirror;)V", "checkMethodSignature", "checkMixPermissionType", "checkNotEmpty", "rpe", "Lpermissions/dispatcher/processor/RuntimePermissionsElement;", "checkPrivateMethods", "findAndValidateProcessorUnit", "Lpermissions/dispatcher/processor/ProcessorUnit;", "K", "units", "element", "Ljavax/lang/model/element/Element;", "processor"})
public final class ValidatorsKt {
    private static final String WRITE_SETTINGS = "android.permission.WRITE_SETTINGS";
    private static final String SYSTEM_ALERT_WINDOW = "android.permission.SYSTEM_ALERT_WINDOW";

    @NotNull
    public static final <K> ProcessorUnit<K> findAndValidateProcessorUnit(@NotNull List<? extends ProcessorUnit<? extends K>> units, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull(units, (String)"units");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TypeMirror type = element.asType();
        try {
            Object element$iv2;
            block3: {
                Iterable $receiver$iv = units;
                for (Object element$iv2 : $receiver$iv) {
                    ProcessorUnit it = (ProcessorUnit)element$iv2;
                    TypeMirror typeMirror = type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"type");
                    if (!ExtensionsKt.isSubtypeOf(typeMirror, it.getTargetType())) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            return (ProcessorUnit)element$iv2;
        }
        catch (NoSuchElementException ex) {
            TypeMirror typeMirror = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"type");
            throw (Throwable)new WrongClassException(typeMirror);
        }
    }

    public static final <A extends Annotation> void checkDuplicatedValue(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        ArrayList<List> allItems = new ArrayList<List>();
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            A a = it.getAnnotation(annotationClass);
            Intrinsics.checkExpressionValueIsNotNull(a, (String)"it.getAnnotation(annotationClass)");
            List permissionValue = CollectionsKt.sorted((Iterable)ExtensionsKt.permissionValue(a));
            Iterable $receiver$iv2 = allItems;
            for (Object element$iv2 : $receiver$iv2) {
                List oldItem = (List)element$iv2;
                if (!Intrinsics.areEqual((Object)oldItem, (Object)permissionValue)) continue;
                throw (Throwable)new DuplicatedValueException(permissionValue, it, annotationClass);
            }
            allItems.add(permissionValue);
        }
    }

    public static final <A extends Annotation> void checkNotEmpty(@NotNull List<? extends ExecutableElement> items, @NotNull RuntimePermissionsElement rpe, @NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)rpe, (String)"rpe");
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        if (items.isEmpty()) {
            throw (Throwable)new NoAnnotatedMethodsException(rpe, annotationClass);
        }
    }

    public static final <A extends Annotation> void checkPrivateMethods(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            if (!it.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            throw (Throwable)new PrivateMethodException(it, annotationClass);
        }
    }

    public static final void checkMethodSignature(@NotNull List<? extends ExecutableElement> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            TypeMirror typeMirror = it.getReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"it.returnType");
            if (typeMirror.getKind() != TypeKind.VOID) {
                throw (Throwable)new WrongReturnTypeException(it);
            }
            List<? extends TypeMirror> list = it.getThrownTypes();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.thrownTypes");
            Collection collection = list;
            if (!(!collection.isEmpty())) continue;
            throw (Throwable)new NoThrowsAllowedException(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkMethodParameters(@NotNull List<? extends ExecutableElement> items, int numParams, TypeMirror ... requiredTypes) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)requiredTypes, (String)"requiredTypes");
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            List<? extends VariableElement> params = it.getParameters();
            if (numParams == 0) {
                List<? extends VariableElement> list = params;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"params");
                Collection collection = list;
                if (!collection.isEmpty()) {
                    throw (Throwable)new NoParametersAllowedException(it);
                }
            }
            if (numParams != params.size()) {
                throw (Throwable)new WrongParametersException(it, requiredTypes);
            }
            List<? extends VariableElement> list = params;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"params");
            Iterable $receiver$iv2 = list;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                void param;
                int n = index$iv++;
                VariableElement variableElement = (VariableElement)item$iv;
                int i = n;
                TypeMirror requiredType = requiredTypes[i];
                if (PermissionsProcessorKt.getTYPE_UTILS().isSameType(param.asType(), requiredType)) continue;
                throw (Throwable)new WrongParametersException(it, requiredTypes);
            }
        }
    }

    public static final <A extends Annotation> void checkMixPermissionType(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull(annotationClass, (String)"annotationClass");
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            A a = it.getAnnotation(annotationClass);
            Intrinsics.checkExpressionValueIsNotNull(a, (String)"it.getAnnotation(annotationClass)");
            List<String> permissionValue = ExtensionsKt.permissionValue(a);
            if (permissionValue.size() <= 1) continue;
            if (permissionValue.contains(WRITE_SETTINGS)) {
                throw (Throwable)new MixPermissionTypeException(it, WRITE_SETTINGS);
            }
            if (!permissionValue.contains(SYSTEM_ALERT_WINDOW)) continue;
            throw (Throwable)new MixPermissionTypeException(it, SYSTEM_ALERT_WINDOW);
        }
    }

    public static final void checkDuplicatedMethodName(@NotNull List<? extends ExecutableElement> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Iterable $receiver$iv = items;
        for (Object element$iv : $receiver$iv) {
            ExecutableElement executableElement;
            Object v0;
            ExecutableElement item;
            block2: {
                item = (ExecutableElement)element$iv;
                Iterable $receiver$iv2 = items;
                for (Object element$iv2 : $receiver$iv2) {
                    ExecutableElement it = (ExecutableElement)element$iv2;
                    if (!(Intrinsics.areEqual((Object)it, (Object)item) ^ true && Intrinsics.areEqual((Object)it.getSimpleName(), (Object)item.getSimpleName()))) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            ExecutableElement executableElement2 = v0;
            if (executableElement2 == null) continue;
            ExecutableElement it = executableElement = executableElement2;
            throw (Throwable)new DuplicatedMethodNameException(item);
        }
    }
}

