/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.actioncable;

import com.google.gson.JsonElement;
import com.hosopy.actioncable.ActionCableException;
import com.hosopy.actioncable.Channel;
import com.hosopy.actioncable.Command;
import com.hosopy.actioncable.Consumer;
import com.hosopy.actioncable.Subscription;
import com.hosopy.actioncable.SubscriptionProxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Subscriptions {
    private Consumer consumer;
    private final Map<Subscription, SubscriptionProxy> subscriptionProxies = new ConcurrentHashMap<Subscription, SubscriptionProxy>();

    Subscriptions(Consumer consumer) {
        this.consumer = consumer;
    }

    public <T extends Subscription> T create(Channel channel, Class<T> subscription) {
        SubscriptionProxy<T> subscriptionProxy = new SubscriptionProxy<T>(this.consumer, channel, subscription);
        this.add(subscriptionProxy);
        return subscriptionProxy.getProxy();
    }

    public Subscription create(Channel channel) {
        return this.create(channel, Subscription.class);
    }

    public void remove(Subscription subscription) {
        this.forget(subscription);
        if (!this.contains(subscription)) {
            this.consumer.send(Command.unsubscribe(subscription.getIdentifier()));
        }
    }

    Consumer getConsumer() {
        return this.consumer;
    }

    void reload() {
        for (SubscriptionProxy subscriptionProxy : this.subscriptionProxies.values()) {
            this.sendSubscribeCommand(subscriptionProxy);
        }
    }

    void reject(String identifier) {
        for (SubscriptionProxy subscriptionProxy : this.subscriptionProxies.values()) {
            if (!subscriptionProxy.getIdentifier().equals(identifier)) continue;
            this.forget((Subscription)subscriptionProxy.getProxy());
            subscriptionProxy.notifyRejected();
        }
    }

    void notifyReceived(String identifier, JsonElement data) {
        for (SubscriptionProxy subscriptionProxy : this.subscriptionProxies.values()) {
            if (!subscriptionProxy.getIdentifier().equals(identifier)) continue;
            subscriptionProxy.notifyReceived(data);
        }
    }

    void notifyConnected(String identifier) {
        for (SubscriptionProxy subscriptionProxy : this.subscriptionProxies.values()) {
            if (!subscriptionProxy.getIdentifier().equals(identifier)) continue;
            subscriptionProxy.notifyConnected();
        }
    }

    void notifyDisconnected() {
        for (SubscriptionProxy subscription : this.subscriptionProxies.values()) {
            subscription.notifyDisconnected();
        }
    }

    void notifyFailed(ActionCableException e) {
        for (SubscriptionProxy subscription : this.subscriptionProxies.values()) {
            subscription.notifyFailed(e);
        }
    }

    boolean contains(Subscription subscription) {
        return this.subscriptionProxies.containsKey(subscription);
    }

    private void add(SubscriptionProxy subscriptionProxy) {
        this.subscriptionProxies.put((Subscription)subscriptionProxy.getProxy(), subscriptionProxy);
        this.sendSubscribeCommand(subscriptionProxy);
    }

    private void forget(Subscription subscription) {
        this.subscriptionProxies.remove(subscription);
    }

    private boolean sendSubscribeCommand(SubscriptionProxy subscriptionProxy) {
        return this.consumer.send(Command.subscribe(subscriptionProxy.getIdentifier()));
    }
}

