/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.actioncable;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.hosopy.actioncable.ActionCableException;
import com.hosopy.actioncable.Channel;
import com.hosopy.actioncable.Command;
import com.hosopy.actioncable.Consumer;
import com.hosopy.actioncable.Subscription;
import com.hosopy.actioncable.annotation.Data;
import com.hosopy.actioncable.annotation.Perform;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class SubscriptionProxy<T extends Subscription> {
    private Consumer consumer;
    private Channel channel;
    private T proxy;
    private Subscription.ConnectedCallback onConnected;
    private Subscription.DisconnectedCallback onDisconnected;
    private Subscription.RejectedCallback onRejected;
    private Subscription.ReceivedCallback onReceived;
    private Subscription.FailedCallback onFailure;

    SubscriptionProxy(Consumer consumer, Channel channel, Class<T> subscription) {
        this.consumer = consumer;
        this.channel = channel;
        this.proxy = (Subscription)Proxy.newProxyInstance(subscription.getClassLoader(), new Class[]{subscription}, (InvocationHandler)new CustomInvocationHandler(this));
    }

    T getProxy() {
        return this.proxy;
    }

    String getIdentifier() {
        return this.channel.toIdentifier();
    }

    void onConnected(Subscription.ConnectedCallback callback) {
        this.onConnected = callback;
    }

    void onDisconnected(Subscription.DisconnectedCallback callback) {
        this.onDisconnected = callback;
    }

    void onRejected(Subscription.RejectedCallback callback) {
        this.onRejected = callback;
    }

    void onReceived(Subscription.ReceivedCallback callback) {
        this.onReceived = callback;
    }

    void onFailure(Subscription.FailedCallback callback) {
        this.onFailure = callback;
    }

    void perform(String action, JsonObject data) {
        data.addProperty("action", action);
        this.consumer.send(Command.message(this.channel.toIdentifier(), data));
    }

    void perform(String action) {
        this.perform(action, new JsonObject());
    }

    void notifyConnected() {
        if (this.onConnected != null) {
            this.onConnected.call();
        }
    }

    void notifyRejected() {
        if (this.onRejected != null) {
            this.onRejected.call();
        }
    }

    void notifyReceived(JsonElement data) {
        if (this.onReceived != null) {
            this.onReceived.call(data);
        }
    }

    void notifyDisconnected() {
        if (this.onDisconnected != null) {
            this.onDisconnected.call();
        }
    }

    void notifyFailed(ActionCableException e) {
        if (this.onFailure != null) {
            this.onFailure.call(e);
        }
    }

    private static class CustomInvocationHandler
    implements InvocationHandler {
        private SubscriptionProxy subscriptionProxy;

        CustomInvocationHandler(SubscriptionProxy subscriptionProxy) {
            this.subscriptionProxy = subscriptionProxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (method.getDeclaringClass() == Subscription.class) {
                if (method.getName().equals("getIdentifier")) {
                    return this.subscriptionProxy.getIdentifier();
                }
                if (method.getName().equals("onConnected")) {
                    this.subscriptionProxy.onConnected((Subscription.ConnectedCallback)args[0]);
                    return proxy;
                }
                if (method.getName().equals("onDisconnected")) {
                    this.subscriptionProxy.onDisconnected((Subscription.DisconnectedCallback)args[0]);
                    return proxy;
                }
                if (method.getName().equals("onRejected")) {
                    this.subscriptionProxy.onRejected((Subscription.RejectedCallback)args[0]);
                    return proxy;
                }
                if (method.getName().equals("onReceived")) {
                    this.subscriptionProxy.onReceived((Subscription.ReceivedCallback)args[0]);
                    return proxy;
                }
                if (method.getName().equals("onFailed")) {
                    this.subscriptionProxy.onFailure((Subscription.FailedCallback)args[0]);
                    return proxy;
                }
                if (method.getName().equals("perform") && method.getParameterTypes().length == 1) {
                    this.subscriptionProxy.perform((String)args[0]);
                } else if (method.getName().equals("perform") && method.getParameterTypes().length == 2) {
                    this.subscriptionProxy.perform((String)args[0], (JsonObject)args[1]);
                }
            } else {
                Perform performAnnotation = this.getPerformAnnotation(method);
                if (performAnnotation != null) {
                    String action = performAnnotation.value();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Annotation[][] annotations = method.getParameterAnnotations();
                    if (parameterTypes.length == 0 && annotations.length == 0) {
                        this.subscriptionProxy.perform(action);
                    } else {
                        if (parameterTypes.length != annotations.length) {
                            throw new IllegalArgumentException("All method parameters must be annotated");
                        }
                        JsonObject data = new JsonObject();
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            Annotation[] currentAnnotations = annotations[i];
                            Data dataAnnotation = this.getDataAnnotation(currentAnnotations);
                            if (dataAnnotation == null) {
                                throw new IllegalArgumentException(i + "th parameter of " + method.getDeclaringClass().getName() + "#" + method.getName() + " must be annotated by @Data.");
                            }
                            if (args[i] == null) {
                                data.add(dataAnnotation.value(), (JsonElement)JsonNull.INSTANCE);
                                continue;
                            }
                            if (args[i] instanceof Number) {
                                data.addProperty(dataAnnotation.value(), (Number)args[i]);
                                continue;
                            }
                            if (args[i] instanceof Boolean) {
                                data.addProperty(dataAnnotation.value(), (Boolean)args[i]);
                                continue;
                            }
                            if (args[i] instanceof String || args[i] instanceof Character) {
                                data.addProperty(dataAnnotation.value(), (String)args[i]);
                                continue;
                            }
                            if (args[i] instanceof JsonElement) {
                                data.add(dataAnnotation.value(), (JsonElement)args[i]);
                                continue;
                            }
                            throw new IllegalArgumentException("Type of " + i + "th parameter of " + method.getDeclaringClass().getName() + "#" + method.getName() + " is not supported.");
                        }
                        this.subscriptionProxy.perform(action, data);
                    }
                }
            }
            return null;
        }

        private Perform getPerformAnnotation(Method method) {
            return method.getAnnotation(Perform.class);
        }

        private Data getDataAnnotation(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() != Data.class) continue;
                return (Data)annotation;
            }
            return null;
        }
    }
}

