/*
 * Decompiled with CFR 0.152.
 */
package com.github.hi_fi.httpclient.security;

import com.github.hi_fi.httpclient.domain.Authentication;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class Auth {
    private CredentialsProvider credsProvider = new BasicCredentialsProvider();

    public AuthCache getAuthCache(Authentication auth, HttpHost target) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme authScheme = null;
        switch (auth.getType()) {
            case BASIC: {
                authScheme = new BasicScheme();
                break;
            }
            case DIGEST: {
                authScheme = new DigestScheme();
                break;
            }
        }
        authCache.put(target, (AuthScheme)authScheme);
        return authCache;
    }

    public CredentialsProvider getCredentialsProvider(Authentication auth, HttpHost target) {
        this.credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
        return this.credsProvider;
    }
}

