/*
 * Decompiled with CFR 0.152.
 */
package com.github.hi_fi.httpclient.domain;

import com.github.hi_fi.httpclient.domain.Authentication;
import com.github.hi_fi.httpclient.domain.Proxy;
import com.github.hi_fi.httpclient.domain.ResponseData;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private String alias;
    private String url;
    private HttpClientContext context;
    private HttpClient client;
    private ResponseData responseData = new ResponseData();
    private HttpResponse response;
    private Authentication authentication;
    private HttpHost httpHost;
    private String verify;
    private Map<String, String> headers;
    private HostnameVerifier hostnameVerifier;
    private TrustStrategy trustStrategy;
    private String password;
    private Proxy proxy = new Proxy(null);

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public HttpClientContext getContext() {
        return this.context;
    }

    public void setContext(HttpClientContext context) {
        this.context = context;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                this.setResponseBody(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
            }
            this.responseData.setStatusCode(response.getStatusLine().getStatusCode());
            this.responseData.setHeaders(response.getAllHeaders());
        }
        catch (ParseException e) {
            throw new RuntimeException("Parsing exception. Message: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception. Message: " + e.getMessage());
        }
    }

    public String getResponseBody() {
        return this.responseData.getText();
    }

    private void setResponseBody(String responseBody) {
        this.responseData.setText(responseBody);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        if (url.endsWith("/")) {
            this.url = url.substring(0, url.length() - 1);
        }
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public void setHttpHost(HttpHost httpHost) {
        this.httpHost = httpHost;
    }

    public ResponseData getResponseData() {
        return this.responseData;
    }

    public String getVerify() {
        return this.verify;
    }

    public void setVerify(String verify) {
        this.verify = verify;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public TrustStrategy getTrustStrategy() {
        return this.trustStrategy;
    }

    public void setTrustStrategy(TrustStrategy trustStrategy) {
        this.trustStrategy = trustStrategy;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

