/*
 * Decompiled with CFR 0.152.
 */
package com.github.hervian.reflection;

import com.github.hervian.reflection.DelegateInvocationResult;
import com.github.hervian.reflection.Fun;
import com.github.hervian.reflection.FunctionInvocationResult;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public abstract class Delegate<RETURN, METHOD_REF extends Fun<RETURN>> {
    private List<METHOD_REF> methodRefs = new LinkedList<METHOD_REF>();

    public Delegate(METHOD_REF[] methodRefs) {
        this.add((Fun[])methodRefs);
    }

    public List<METHOD_REF> getMethodRefs() {
        return Collections.unmodifiableList(this.methodRefs);
    }

    protected abstract RETURN invoke(METHOD_REF var1, Object ... var2) throws Exception;

    protected DelegateInvocationResult<RETURN> invoke(Object ... args) throws Exception {
        return this.invoke(InvocationStrategy.THROW_EXCEPTIONS, args);
    }

    protected DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(Object ... args) {
        return this.invoke(InvocationStrategy.CATCH_AND_AGGREGATE_EXCEPTIONS, args);
    }

    protected DelegateInvocationResult<RETURN> invoke(InvocationStrategy invocationStrategy, Object ... args) throws Exception {
        return this.invokeMethodReferences(invocationStrategy, args);
    }

    private DelegateInvocationResult<RETURN> invokeMethodReferences(InvocationStrategy invocationStrategy, Object ... args) throws Exception {
        DelegateInvocationResult.DelegateInvocationResultBuilder delegateInvocationResultBuilder = DelegateInvocationResult.builder();
        boolean oneOrMoreExceptionsThrown = false;
        for (Fun m : this.getMethodRefs()) {
            FunctionInvocationResult.FunctionInvocationResultBuilder<RETURN> builder = FunctionInvocationResult.builder();
            builder.method(m.toMethod());
            try {
                RETURN result = this.invoke((METHOD_REF)m, args);
                builder.result(result);
            }
            catch (Exception e) {
                oneOrMoreExceptionsThrown = true;
                if (InvocationStrategy.THROW_EXCEPTIONS == invocationStrategy) {
                    throw e;
                }
                builder.exception(e);
            }
            delegateInvocationResultBuilder.oneOrMoreExceptionsThrown(oneOrMoreExceptionsThrown);
            delegateInvocationResultBuilder.functionInvocationResult(builder.build());
        }
        return delegateInvocationResultBuilder.build();
    }

    @SafeVarargs
    public final void add(METHOD_REF ... methodRefVarArg) {
        if (methodRefVarArg != null) {
            for (METHOD_REF methodRef : methodRefVarArg) {
                if (methodRef == null) continue;
                this.methodRefs.add(methodRef);
            }
        }
    }

    @SafeVarargs
    public final boolean remove(METHOD_REF ... methodRefVarArg) {
        boolean removed = false;
        if (methodRefVarArg != null) {
            for (Object methodRef : methodRefVarArg) {
                if (methodRef == null) continue;
                removed = this.methodRefs.removeIf(e -> e.equals(methodRef));
            }
        }
        return removed;
    }

    public static interface IDelegator {
        public void invoke();

        public void invokeAndAggregateExceptions();

        public List<?> getMethodRefs();
    }

    public static class With9ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9>
    extends Delegate<Void, Fun.With9ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9>> {
        public With9ParamsAndVoid(Fun.With9ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8, @NonNull @NotNull PARAM9 param9) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            if (param9 == null) {
                throw new NullPointerException("param9 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8, @NonNull @NotNull PARAM9 param9) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            if (param9 == null) {
                throw new NullPointerException("param9 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7, param8, param9);
        }

        @Override
        protected Void invoke(Fun.With9ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            return null;
        }
    }

    public static class With9Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9>
    extends Delegate<RETURN, Fun.With9Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9>> {
        public With9Params(Fun.With9Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8, @NonNull @NotNull PARAM9 param9) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            if (param9 == null) {
                throw new NullPointerException("param9 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8, @NonNull @NotNull PARAM9 param9) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            if (param9 == null) {
                throw new NullPointerException("param9 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7, param8, param9);
        }

        @Override
        protected RETURN invoke(Fun.With9Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8, PARAM9> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
        }
    }

    public static class With8ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8>
    extends Delegate<Void, Fun.With8ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8>> {
        public With8ParamsAndVoid(Fun.With8ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7, param8});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7, param8);
        }

        @Override
        protected Void invoke(Fun.With8ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            return null;
        }
    }

    public static class With8Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8>
    extends Delegate<RETURN, Fun.With8Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8>> {
        public With8Params(Fun.With8Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7, param8});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7, @NonNull @NotNull PARAM8 param8) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            if (param8 == null) {
                throw new NullPointerException("param8 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7, param8);
        }

        @Override
        protected RETURN invoke(Fun.With8Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7, PARAM8> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
        }
    }

    public static class With7ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7>
    extends Delegate<Void, Fun.With7ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7>> {
        public With7ParamsAndVoid(Fun.With7ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7);
        }

        @Override
        protected Void invoke(Fun.With7ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            return null;
        }
    }

    public static class With7Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7>
    extends Delegate<RETURN, Fun.With7Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7>> {
        public With7Params(Fun.With7Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6, param7});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6, @NonNull @NotNull PARAM7 param7) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            if (param7 == null) {
                throw new NullPointerException("param7 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6, param7);
        }

        @Override
        protected RETURN invoke(Fun.With7Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6, PARAM7> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        }
    }

    public static class With6ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6>
    extends Delegate<Void, Fun.With6ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6>> {
        public With6ParamsAndVoid(Fun.With6ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6);
        }

        @Override
        protected Void invoke(Fun.With6ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5]);
            return null;
        }
    }

    public static class With6Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6>
    extends Delegate<RETURN, Fun.With6Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6>> {
        public With6Params(Fun.With6Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5, param6});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5, @NonNull @NotNull PARAM6 param6) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            if (param6 == null) {
                throw new NullPointerException("param6 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5, param6);
        }

        @Override
        protected RETURN invoke(Fun.With6Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5, PARAM6> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4], args[5]);
        }
    }

    public static class With5ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5>
    extends Delegate<Void, Fun.With5ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5>> {
        public With5ParamsAndVoid(Fun.With5ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5);
        }

        @Override
        protected Void invoke(Fun.With5ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4, PARAM5> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4]);
            return null;
        }
    }

    public static class With5Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5>
    extends Delegate<RETURN, Fun.With5Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5>> {
        public With5Params(Fun.With5Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4, param5});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4, @NonNull @NotNull PARAM5 param5) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            if (param5 == null) {
                throw new NullPointerException("param5 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4, param5);
        }

        @Override
        protected RETURN invoke(Fun.With5Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4, PARAM5> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static class With4ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4>
    extends Delegate<Void, Fun.With4ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4>> {
        public With4ParamsAndVoid(Fun.With4ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4);
        }

        @Override
        protected Void invoke(Fun.With4ParamsAndVoid<PARAM1, PARAM2, PARAM3, PARAM4> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2], args[3]);
            return null;
        }
    }

    public static class With4Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4>
    extends Delegate<RETURN, Fun.With4Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4>> {
        public With4Params(Fun.With4Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3, param4});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3, @NonNull @NotNull PARAM4 param4) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            if (param4 == null) {
                throw new NullPointerException("param4 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3, param4);
        }

        @Override
        protected RETURN invoke(Fun.With4Params<RETURN, PARAM1, PARAM2, PARAM3, PARAM4> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2], args[3]);
        }
    }

    public static class With3ParamsAndVoid<PARAM1, PARAM2, PARAM3>
    extends Delegate<Void, Fun.With3ParamsAndVoid<PARAM1, PARAM2, PARAM3>> {
        public With3ParamsAndVoid(Fun.With3ParamsAndVoid<PARAM1, PARAM2, PARAM3> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3);
        }

        @Override
        protected Void invoke(Fun.With3ParamsAndVoid<PARAM1, PARAM2, PARAM3> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1], args[2]);
            return null;
        }
    }

    public static class With3Params<RETURN, PARAM1, PARAM2, PARAM3>
    extends Delegate<RETURN, Fun.With3Params<RETURN, PARAM1, PARAM2, PARAM3>> {
        public With3Params(Fun.With3Params<RETURN, PARAM1, PARAM2, PARAM3> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2, param3});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2, @NonNull @NotNull PARAM3 param3) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            if (param3 == null) {
                throw new NullPointerException("param3 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2, param3);
        }

        @Override
        protected RETURN invoke(Fun.With3Params<RETURN, PARAM1, PARAM2, PARAM3> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1], args[2]);
        }
    }

    public static class With2ParamsAndVoid<PARAM1, PARAM2>
    extends Delegate<Void, Fun.With2ParamsAndVoid<PARAM1, PARAM2>> {
        public With2ParamsAndVoid(Fun.With2ParamsAndVoid<PARAM1, PARAM2> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2});
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2);
        }

        @Override
        protected Void invoke(Fun.With2ParamsAndVoid<PARAM1, PARAM2> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0], args[1]);
            return null;
        }
    }

    public static class With2Params<RETURN, PARAM1, PARAM2>
    extends Delegate<RETURN, Fun.With2Params<RETURN, PARAM1, PARAM2>> {
        public With2Params(Fun.With2Params<RETURN, PARAM1, PARAM2> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            return super.invoke(new Object[]{param1, param2});
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1, @NonNull @NotNull PARAM2 param2) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            if (param2 == null) {
                throw new NullPointerException("param2 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1, param2);
        }

        @Override
        protected RETURN invoke(Fun.With2Params<RETURN, PARAM1, PARAM2> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0], args[1]);
        }
    }

    public static class With1ParamAndVoid<PARAM1>
    extends Delegate<Void, Fun.With1ParamAndVoid<PARAM1>> {
        public With1ParamAndVoid(Fun.With1ParamAndVoid<PARAM1> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke(@NonNull @NotNull PARAM1 param1) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            return super.invoke(param1);
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1);
        }

        @Override
        protected Void invoke(Fun.With1ParamAndVoid<PARAM1> function, Object ... args) throws Exception {
            function.invoke(args == null ? null : args[0]);
            return null;
        }
    }

    public static class With1Param<RETURN, PARAM1>
    extends Delegate<RETURN, Fun.With1Param<RETURN, PARAM1>> {
        public With1Param(Fun.With1Param<RETURN, PARAM1> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke(@NonNull @NotNull PARAM1 param1) throws Exception {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            return super.invoke(param1);
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions(@NonNull @NotNull PARAM1 param1) {
            if (param1 == null) {
                throw new NullPointerException("param1 is marked non-null but is null");
            }
            return super.invokeAndAggregateExceptions(param1);
        }

        @Override
        protected RETURN invoke(Fun.With1Param<RETURN, PARAM1> function, Object ... args) throws Exception {
            return function.invoke(args == null ? null : args[0]);
        }
    }

    public static class With0ParamsAndVoid
    extends Delegate<Void, Fun.With0ParamsAndVoid<?>> {
        public With0ParamsAndVoid(Fun.With0ParamsAndVoid ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<Void> invoke() throws Exception {
            return super.invoke(new Object[0]);
        }

        public DelegateInvocationResult<Void> invokeAndAggregateExceptions() {
            return super.invokeAndAggregateExceptions(new Object[0]);
        }

        @Override
        protected Void invoke(Fun.With0ParamsAndVoid function, Object ... args) throws Exception {
            function.invoke();
            return null;
        }
    }

    public static class With0Params<RETURN>
    extends Delegate<RETURN, Fun.With0Params<RETURN>> {
        @SafeVarargs
        public With0Params(Fun.With0Params<RETURN> ... methodRefs) {
            super((Fun[])methodRefs);
        }

        public DelegateInvocationResult<RETURN> invoke() throws Exception {
            return super.invoke(new Object[0]);
        }

        public DelegateInvocationResult<RETURN> invokeAndAggregateExceptions() {
            return super.invokeAndAggregateExceptions(new Object[0]);
        }

        @Override
        protected RETURN invoke(Fun.With0Params<RETURN> function, Object ... args) throws Exception {
            return function.invoke();
        }
    }

    public static enum InvocationStrategy {
        THROW_EXCEPTIONS,
        CATCH_AND_AGGREGATE_EXCEPTIONS;

    }
}

