/*
 * Decompiled with CFR 0.152.
 */
package com.github.hervian.lambdas;

import com.github.hervian.lambdas.Lambda;
import com.github.hervian.lambdas.util.GenerateLambdaProcessor;
import com.github.hervian.reflection.Fun;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class LambdaFactory {
    static <DUMMY> Lambda create(Fun.With0ParamsAndVoid<DUMMY> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1> Lambda create(Fun.With1ParamAndVoid<T1> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2> Lambda create(Fun.With2ParamsAndVoid<T1, T2> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3> Lambda create(Fun.With3ParamsAndVoid<T1, T2, T3> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4> Lambda create(Fun.With4ParamsAndVoid<T1, T2, T3, T4> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4, T5> Lambda create(Fun.With5ParamsAndVoid<T1, T2, T3, T4, T5> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4, T5, T6> Lambda create(Fun.With6ParamsAndVoid<T1, T2, T3, T4, T5, T6> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4, T5, T6, T7> Lambda create(Fun.With7ParamsAndVoid<T1, T2, T3, T4, T5, T6, T7> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4, T5, T6, T7, T8> Lambda create(Fun.With8ParamsAndVoid<T1, T2, T3, T4, T5, T6, T7, T8> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Lambda create(Fun.With9ParamsAndVoid<T1, T2, T3, T4, T5, T6, T7, T8, T9> methodRef) throws Throwable {
        return LambdaFactory.create(methodRef.toMethod());
    }

    public static Lambda create(Method method) throws Throwable {
        return LambdaFactory.privateCreate(method, false);
    }

    public static Lambda createSpecial(Method method) throws Throwable {
        return LambdaFactory.privateCreate(method, true);
    }

    private static Lambda privateCreate(Method method, boolean createSpecial) throws Throwable {
        Class<?> returnType = method.getReturnType();
        String signatureName = GenerateLambdaProcessor.getMethodName(returnType.getSimpleName());
        return createSpecial ? LambdaFactory.createSpecial(method, Lambda.class, signatureName) : LambdaFactory.create(method, Lambda.class, signatureName);
    }

    private static Lambda create(Method method, MethodHandles.Lookup lookup, boolean invokeSpecial) throws Throwable {
        Class<?> returnType = method.getReturnType();
        String signatureName = GenerateLambdaProcessor.getMethodName(returnType.getSimpleName());
        return LambdaFactory.createLambda(method, lookup, Lambda.class, signatureName, invokeSpecial);
    }

    public static <T> T create(Method method, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.create(method, interfaceClass, signatatureName, false);
    }

    public static <T> T createSpecial(Method method, Class<T> interfaceClass, String signatatureName) throws Throwable {
        return LambdaFactory.create(method, interfaceClass, signatatureName, true);
    }

    private static <T> T create(Method method, Class<T> interfaceClass, String signatureName, boolean invokeSpecial) throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), MethodHandles.lookup());
        return LambdaFactory.createLambda(method, lookup, interfaceClass, signatureName, invokeSpecial);
    }

    private static <T> T createLambda(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatatureName, boolean createSpecial) throws Throwable {
        lookup = lookup.in(method.getDeclaringClass());
        return LambdaFactory.privateCreateLambda(method, lookup, interfaceClass, signatatureName, createSpecial);
    }

    private static <T> T privateCreateLambda(Method method, MethodHandles.Lookup lookup, Class<T> interfaceClass, String signatureName, boolean createSpecial) throws Throwable {
        MethodHandle methodHandle = createSpecial ? lookup.unreflectSpecial(method, method.getDeclaringClass()) : lookup.unreflect(method);
        MethodType instantiatedMethodType = methodHandle.type();
        MethodType signature = LambdaFactory.createLambdaMethodType(method, instantiatedMethodType);
        CallSite site = LambdaFactory.createCallSite(signatureName, lookup, methodHandle, instantiatedMethodType, signature, interfaceClass);
        MethodHandle factory = site.getTarget();
        return (T)factory.invoke();
    }

    private static MethodType createLambdaMethodType(Method method, MethodType instantiatedMethodType) {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        MethodType signature = isStatic ? instantiatedMethodType : instantiatedMethodType.changeParameterType(0, Object.class);
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (!Object.class.isAssignableFrom(params[i])) continue;
            signature = signature.changeParameterType(isStatic ? i : i + 1, Object.class);
        }
        if (Object.class.isAssignableFrom((Class<?>)signature.returnType())) {
            signature = signature.changeReturnType(Object.class);
        }
        return signature;
    }

    private static CallSite createCallSite(String signatureName, MethodHandles.Lookup lookup, MethodHandle methodHandle, MethodType instantiatedMethodType, MethodType signature, Class<?> interfaceClass) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, signatureName, MethodType.methodType(interfaceClass), signature, methodHandle, instantiatedMethodType);
    }
}

