/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.animation.Animation;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.girod.javafx.svgimage.GlobalConfig;
import org.girod.javafx.svgimage.LoaderContext;
import org.girod.javafx.svgimage.LoaderParameters;
import org.girod.javafx.svgimage.SVGImage;
import org.girod.javafx.svgimage.xml.AnimationBuilder;
import org.girod.javafx.svgimage.xml.FilterSpec;
import org.girod.javafx.svgimage.xml.GradientSpec;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.SVGParsingException;
import org.girod.javafx.svgimage.xml.SVGShapeBuilder;
import org.girod.javafx.svgimage.xml.SVGStyleBuilder;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.SpanGroup;
import org.girod.javafx.svgimage.xml.SymbolSpec;
import org.girod.javafx.svgimage.xml.TransformUtils;
import org.girod.javafx.svgimage.xml.Viewbox;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;
import org.girod.javafx.svgimage.xml.XMLRoot;
import org.girod.javafx.svgimage.xml.XMLTreeHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGLoader
implements SVGTags {
    private final URL url;
    private final String content;
    private final SVGImage root;
    private Viewport viewport = null;
    private final LoaderContext context;

    private SVGLoader(URL url, LoaderParameters params) {
        this.url = url;
        this.content = null;
        this.root = new SVGImage();
        this.context = new LoaderContext(this.root, params, url);
    }

    private SVGLoader(String content, LoaderParameters params) {
        this.url = null;
        this.content = content;
        this.root = new SVGImage();
        this.context = new LoaderContext(this.root, params, this.url);
    }

    public static SVGImage load(File file) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.load(url);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage load(URL url) throws SVGParsingException {
        SVGLoader loader = new SVGLoader(url, new LoaderParameters());
        SVGImage img = loader.loadImpl();
        return img;
    }

    public static SVGImage load(String content) throws SVGParsingException {
        SVGLoader loader = new SVGLoader(content, new LoaderParameters());
        SVGImage img = loader.loadImpl();
        return img;
    }

    public static SVGImage load(File file, String styleSheets) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.load(url, styleSheets);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage load(File file, LoaderParameters params) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.load(url, params);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage load(URL url, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        return SVGLoader.load(url, params);
    }

    public static SVGImage load(String content, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        return SVGLoader.load(content, params);
    }

    public static SVGImage loadScaled(File file, double scale) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.loadScaled(url, scale);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage loadScaled(URL url, double scale) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.scale = scale;
        return SVGLoader.load(url, params);
    }

    public static SVGImage loadScaled(String content, double scale) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.scale = scale;
        return SVGLoader.load(content, params);
    }

    public static SVGImage load(File file, double width) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.load(url, width);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage load(URL url, double width) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.width = width;
        return SVGLoader.load(url, params);
    }

    public static SVGImage load(String content, double width) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.width = width;
        return SVGLoader.load(content, params);
    }

    public static SVGImage load(File file, double width, String styleSheets) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.load(url, width, styleSheets);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage load(URL url, double width, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        params.width = width;
        return SVGLoader.load(url, params);
    }

    public static SVGImage load(String content, double width, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        params.width = width;
        return SVGLoader.load(content, params);
    }

    public static SVGImage loadScaled(File file, double scale, String styleSheets) throws SVGParsingException {
        try {
            URL url = file.toURI().toURL();
            return SVGLoader.loadScaled(url, scale, styleSheets);
        }
        catch (MalformedURLException ex) {
            throw new SVGParsingException(ex);
        }
    }

    public static SVGImage loadScaled(URL url, double scale, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        params.scale = scale;
        return SVGLoader.load(url, params);
    }

    public static SVGImage loadScaled(String content, double scale, String styleSheets) throws SVGParsingException {
        LoaderParameters params = new LoaderParameters();
        params.styleSheets = styleSheets;
        params.scale = scale;
        return SVGLoader.load(content, params);
    }

    public static SVGImage load(URL url, LoaderParameters params) throws SVGParsingException {
        SVGLoader loader = new SVGLoader(url, params);
        SVGImage img = loader.loadImpl();
        if (params.centerImage) {
            double theWidth = img.getLayoutBounds().getWidth();
            double theHeight = img.getLayoutBounds().getHeight();
            img.setTranslateX(-theWidth / 2.0);
            img.setTranslateY(-theHeight / 2.0);
        }
        if (params.styleSheets != null) {
            img.getStylesheets().add((Object)params.styleSheets);
        }
        return img;
    }

    private void setViewportScaleImpl(Viewport viewport, LoaderParameters params) {
        if (params.scale > 0.0) {
            viewport.setScale(params.scale, params.scaleLineWidth);
        } else if (params.width > 0.0) {
            double initialWidth = viewport.getBestWidth();
            double scale = params.width / initialWidth;
            viewport.setScale(scale, params.scaleLineWidth);
        }
    }

    public static SVGImage load(String content, LoaderParameters params) throws SVGParsingException {
        SVGLoader loader = new SVGLoader(content, params);
        SVGImage img = loader.loadImpl();
        if (params.centerImage) {
            double theWidth = img.getLayoutBounds().getWidth();
            double theHeight = img.getLayoutBounds().getHeight();
            img.setTranslateX(-theWidth / 2.0);
            img.setTranslateY(-theHeight / 2.0);
        }
        if (params.styleSheets != null) {
            img.getStylesheets().add((Object)params.styleSheets);
        }
        return img;
    }

    private SVGImage loadImpl() throws SVGParsingException {
        if (Platform.isFxApplicationThread()) {
            try {
                return this.loadImplInJFX();
            }
            catch (Exception ex) {
                GlobalConfig.getInstance().handleParsingException(ex);
                return null;
            }
        }
        new JFXPanel();
        FutureTask<SVGImage> future = new FutureTask<SVGImage>(new Callable<SVGImage>(){

            @Override
            public SVGImage call() throws Exception {
                SVGImage img = SVGLoader.this.loadImplInJFX();
                return img;
            }
        });
        Platform.runLater(future);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            return null;
        }
        catch (ExecutionException ex) {
            Throwable th = ex.getCause();
            GlobalConfig.getInstance().handleParsingException(th);
            return null;
        }
    }

    private SVGImage loadImplInJFX() throws IOException {
        this.context.effectsSupported = Platform.isSupported((ConditionalFeature)ConditionalFeature.EFFECT);
        SAXParserFactory saxfactory = SAXParserFactory.newInstance();
        try {
            saxfactory.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
            saxfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            saxfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = saxfactory.newSAXParser();
            XMLTreeHandler handler = new XMLTreeHandler();
            if (this.url != null) {
                parser.parse(this.url.openStream(), (DefaultHandler)handler);
            } else {
                ByteArrayInputStream stream = new ByteArrayInputStream(this.content.getBytes());
                parser.parse((InputStream)stream, (DefaultHandler)handler);
            }
            SVGImage img = this.walk(handler.getRoot());
            if (img != null) {
                if (!this.context.animations.isEmpty()) {
                    img.setAnimations(this.context.animations);
                    if (this.context.params.autoStartAnimations) {
                        this.context.playAnimations();
                    }
                }
                if (this.context.params.applyViewportPosition) {
                    Translate transform = Transform.translate((double)(-this.viewport.getViewboxX()), (double)(-this.viewport.getViewboxY()));
                    img.getTransforms().add((Object)transform);
                }
            }
            return img;
        }
        catch (ParserConfigurationException | SAXException ex) {
            GlobalConfig.getInstance().handleParsingException(ex);
            return null;
        }
    }

    private SVGImage walk(XMLRoot xmlRoot) {
        String name = xmlRoot.getName();
        if (name.equals("svg") && this.viewport == null) {
            this.viewport = ParserUtils.parseViewport(xmlRoot);
            this.setViewportScaleImpl(this.viewport, this.context.params);
            this.context.viewport = this.viewport;
            if (this.viewport != null) {
                this.viewport.scaleNode((Node)this.root);
            }
        }
        this.buildNode(xmlRoot, this.root);
        return this.root;
    }

    private void buildNode(XMLNode xmlNode, Group group) {
        this.buildNode(xmlNode, group, false);
    }

    private void addSymbol(XMLNode xmlNode) {
        if (xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            SymbolSpec symbol = new SymbolSpec(xmlNode);
            Viewbox viewbox = ParserUtils.parseViewbox(xmlNode, this.viewport);
            symbol.setViewbox(viewbox);
            if (xmlNode.hasAttribute("preserveAspectRatio")) {
                boolean preserve = ParserUtils.getPreserveAspectRatio(xmlNode.getAttributeValue("preserveAspectRatio"));
                viewbox.setPreserveAspectRatio(preserve);
            }
            this.context.addSymbol(id, symbol);
        }
    }

    private void addNamedNode(XMLNode xmlNode, Node node) {
        if (node != null && xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            this.context.addNamedNode(id, xmlNode);
        }
    }

    private List<XMLNode> lookForAnimations(XMLNode xmlNode, Node node, Viewport viewport) {
        if (node == null) {
            return new ArrayList<XMLNode>();
        }
        ArrayList<XMLNode> animations = new ArrayList<XMLNode>();
        for (XMLNode childNode : xmlNode.getChildren()) {
            String name;
            switch (name = childNode.getName()) {
                case "animate": 
                case "animateMotion": 
                case "animateTransform": 
                case "set": {
                    animations.add(childNode);
                }
            }
        }
        return animations;
    }

    private void buildNode(XMLNode xmlNode, Group group, boolean acceptDefs) {
        if (group == null) {
            group = new Group();
        }
        List<Object> animations = new ArrayList();
        for (XMLNode childNode : xmlNode.getChildren()) {
            String name;
            Group node = null;
            SpanGroup spanGroup = null;
            switch (name = childNode.getName()) {
                case "style": {
                    this.manageSVGStyle(childNode);
                    break;
                }
                case "rect": {
                    node = SVGShapeBuilder.buildRect(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "circle": {
                    node = SVGShapeBuilder.buildCircle(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "ellipse": {
                    node = SVGShapeBuilder.buildEllipse(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "path": {
                    node = SVGShapeBuilder.buildPath(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "polygon": {
                    node = SVGShapeBuilder.buildPolygon(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "line": {
                    node = SVGShapeBuilder.buildLine(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "polyline": {
                    node = SVGShapeBuilder.buildPolyline(childNode, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "use": {
                    node = SVGShapeBuilder.buildUse(childNode, this.context, null, this.viewport);
                    break;
                }
                case "text": {
                    node = SVGShapeBuilder.buildText(childNode, null, null, this.viewport);
                    if (node == null) {
                        spanGroup = SVGShapeBuilder.buildTSpanGroup(childNode, null, null, this.viewport);
                        this.addNamedNode(childNode, (Node)spanGroup.getTextGroup());
                        animations = this.lookForAnimations(childNode, (Node)spanGroup.getTextGroup(), this.viewport);
                        break;
                    }
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "image": {
                    node = SVGShapeBuilder.buildImage(childNode, this.url, null, null, this.viewport);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "svg": {
                    if (this.viewport == null) {
                        this.context.viewport = this.viewport = ParserUtils.parseViewport(childNode);
                    }
                    node = this.buildGroup(childNode);
                    break;
                }
                case "g": {
                    node = this.buildGroup(childNode);
                    this.addNamedNode(childNode, (Node)node);
                    animations = this.lookForAnimations(childNode, (Node)node, this.viewport);
                    break;
                }
                case "symbol": {
                    this.addSymbol(childNode);
                    break;
                }
                case "defs": {
                    if (!acceptDefs) {
                        this.buildDefs(childNode);
                        break;
                    }
                }
                case "clipPath": {
                    this.buildClipPath(childNode);
                    break;
                }
                case "linearGradient": {
                    if (acceptDefs) {
                        SVGShapeBuilder.buildLinearGradient(this.context.gradientSpecs, this.context.gradients, childNode, this.viewport);
                        break;
                    }
                }
                case "radialGradient": {
                    if (acceptDefs) {
                        SVGShapeBuilder.buildRadialGradient(this.context.gradientSpecs, this.context.gradients, childNode, this.viewport);
                        break;
                    }
                }
                case "filter": {
                    this.buildFilter(childNode);
                }
            }
            if (node != null) {
                List<Animation> animationsList;
                this.addStyles((Node)node, childNode, false);
                group.getChildren().add((Object)node);
                if (animations.isEmpty() || (animationsList = AnimationBuilder.buildAnimations(childNode, (Node)node, animations, this.viewport)) == null) continue;
                this.context.addAnimations(animationsList);
                continue;
            }
            if (spanGroup == null) continue;
            TransformUtils.setTransforms((Node)spanGroup.getTextGroup(), childNode, this.viewport);
            Map<String, String> theStylesMap = ParserUtils.getStyles(childNode);
            Iterator<SpanGroup.TSpan> it2 = spanGroup.getSpans().iterator();
            SpanGroup.TSpan previous = null;
            while (it2.hasNext()) {
                SpanGroup.TSpan tspan = it2.next();
                Text tspanText = tspan.text;
                String theStyles = ParserUtils.mergeStyles(theStylesMap, tspan.node);
                tspan.node.addAttribute("style", theStyles);
                this.addStyles((Node)tspanText, tspan.node, true);
                if (tspan.node.hasAttribute("baseline-shift")) {
                    String shiftValue = tspan.node.getAttributeValue("baseline-shift");
                    ParserUtils.setBaselineShift(tspanText, shiftValue);
                }
                if (!ParserUtils.hasXPosition(tspan.node) && previous != null) {
                    double width = previous.text.getLayoutBounds().getWidth();
                    tspanText.setLayoutX(width + previous.text.getLayoutX());
                }
                previous = tspan;
            }
            group.getChildren().add((Object)spanGroup.getTextGroup());
        }
    }

    private void addStyles(Node node, XMLNode xmlNode, boolean isTextSpan) {
        this.setNodeStyle(node, xmlNode);
        ParserUtils.setVisibility(node, xmlNode);
        ParserUtils.setOpacity(node, xmlNode);
        this.setFilter(node, xmlNode);
        if (!isTextSpan) {
            TransformUtils.setTransforms(node, xmlNode, this.viewport);
        }
    }

    private void manageSVGStyle(XMLNode xmlNode) {
        String cdata;
        if (this.context.svgStyle == null && (cdata = xmlNode.getCDATA()) != null) {
            this.context.svgStyle = SVGStyleBuilder.parseStyle(cdata, this.viewport);
        }
    }

    private void buildDefs(XMLNode xmlNode) {
        this.buildNode(xmlNode, null, true);
        if (!this.context.gradientSpecs.isEmpty()) {
            Map<String, GradientSpec> specs = this.context.gradientSpecs;
            for (GradientSpec spec : specs.values()) {
                spec.resolve(specs, this.viewport);
            }
            for (Map.Entry<String, GradientSpec> entry : specs.entrySet()) {
                GradientSpec spec = entry.getValue();
                this.context.gradients.put(entry.getKey(), spec.getPaint());
            }
        }
    }

    private Group buildGroup(XMLNode xmlNode) {
        Group group = new Group();
        this.buildNode(xmlNode, group);
        return group;
    }

    private void buildFilter(XMLNode xmlNode) {
        if (xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            FilterSpec spec = new FilterSpec();
            this.context.filterSpecs.put(id, spec);
            this.buildFilterEffects(spec, xmlNode);
        }
    }

    private void buildFilterEffects(FilterSpec spec, XMLNode xmlNode) {
        for (XMLNode childNode : xmlNode.getChildren()) {
            String name;
            switch (name = childNode.getName()) {
                case "feGaussianBlur": {
                    SVGShapeBuilder.buildFEGaussianBlur(spec, childNode);
                    break;
                }
                case "feDropShadow": {
                    SVGShapeBuilder.buildFEDropShadow(spec, childNode, this.viewport);
                    break;
                }
                case "feFlood": {
                    SVGShapeBuilder.buildFEFlood(spec, childNode, this.viewport);
                    break;
                }
                case "feImage": {
                    SVGShapeBuilder.buildFEImage(spec, this.url, childNode, this.viewport);
                    break;
                }
                case "feOffset": {
                    SVGShapeBuilder.buildFEOffset(spec, childNode, this.viewport);
                    break;
                }
                case "feComposite": {
                    SVGShapeBuilder.buildFEComposite(spec, childNode);
                }
                case "feMerge": {
                    SVGShapeBuilder.buildFEMerge(spec, childNode);
                    break;
                }
                case "feSpecularLighting": {
                    SVGShapeBuilder.buildFESpecularLighting(spec, childNode, this.viewport);
                    break;
                }
                case "feDiffuseLighting": {
                    SVGShapeBuilder.buildFEDiffuseLighting(spec, childNode, this.viewport);
                }
            }
        }
    }

    private void buildClipPath(XMLNode xmlNode) {
        if (xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            this.context.clippingFactory.addClipSpec(id, xmlNode);
        }
    }

    private void setFilter(Node node, XMLNode xmlNode) {
        Effect effect;
        if (this.context.effectsSupported && xmlNode.hasAttribute("filter") && (effect = this.expressFilter(node, xmlNode.getAttributeValue("filter"))) != null) {
            node.setEffect(effect);
        }
    }

    private Effect expressFilter(Node node, String value) {
        Effect effect = ParserUtils.expressFilter(this.context.filterSpecs, node, value);
        return effect;
    }

    private void setNodeStyle(Node node, XMLNode xmlNode) {
        SVGStyleBuilder.setNodeStyle(node, xmlNode, this.context, this.viewport);
    }
}

