/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.girod.javafx.svgimage.AwtImageConverter;
import org.girod.javafx.svgimage.GlobalConfig;
import org.girod.javafx.svgimage.xml.SVGLibraryException;

public class SVGImage
extends Group {
    private static SnapshotParameters SNAPSHOT_PARAMS = null;
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private List<Animation> animations = new ArrayList<Animation>();

    public static void setDefaultSnapshotParameters(SnapshotParameters params) {
        SNAPSHOT_PARAMS = params;
    }

    public static SnapshotParameters getDefaultSnapshotParameters() {
        return SNAPSHOT_PARAMS;
    }

    void putNode(String id, Node node) {
        this.nodes.put(id, node);
    }

    public boolean hasNode(String id) {
        return this.nodes.containsKey(id);
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations;
    }

    public void playAnimations() {
        if (Platform.isFxApplicationThread()) {
            this.playAnimationsImpl();
        } else {
            new JFXPanel();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SVGImage.this.playAnimationsImpl();
                }
            });
        }
    }

    private void playAnimationsImpl() {
        if (!this.animations.isEmpty()) {
            for (Animation tr : this.animations) {
                tr.play();
            }
        }
    }

    public void stopAnimations() {
        if (Platform.isFxApplicationThread()) {
            this.stopAnimationsImpl();
        } else {
            new JFXPanel();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SVGImage.this.stopAnimationsImpl();
                }
            });
        }
    }

    private void stopAnimationsImpl() {
        if (!this.animations.isEmpty()) {
            for (Animation tr : this.animations) {
                tr.stop();
            }
        }
    }

    public double getWidth() {
        return this.getLayoutBounds().getWidth();
    }

    public double getScaledWidth() {
        return this.getBoundsInParent().getWidth();
    }

    public double getHeight() {
        return this.getLayoutBounds().getHeight();
    }

    public double getScaledHeight() {
        return this.getBoundsInParent().getHeight();
    }

    public Image toImageScaled(double scale) {
        return this.toImageScaled(scale, scale);
    }

    public Image toImageScaled(double scaleX, double scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImage(double width) {
        double initialWidth = this.getLayoutBounds().getWidth();
        double initialHeight = this.getLayoutBounds().getHeight();
        double scaleX = width / initialWidth;
        double scaleY = initialHeight * scaleX;
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImage() {
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
        }
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    public Image toImage(SnapshotParameters params) {
        WritableImage image = this.snapshotImpl(params);
        return image;
    }

    private WritableImage snapshotImplInJFX(SnapshotParameters params) {
        WritableImage image = this.snapshot(params, null);
        return image;
    }

    public boolean snapshot(SnapshotParameters params, String format, File file) throws SVGLibraryException {
        GlobalConfig config = GlobalConfig.getInstance();
        if (config.isSwingAvailable()) {
            try {
                WritableImage image = this.snapshotImpl(params);
                return AwtImageConverter.snapshot(image, params, format, file);
            }
            catch (SVGLibraryException ex) {
                config.handleLibraryException(ex);
                return false;
            }
        }
        config.handleLibraryError("Swing not available");
        return false;
    }

    public boolean snapshot(String format, File file) throws SVGLibraryException {
        SnapshotParameters params = SNAPSHOT_PARAMS;
        if (params == null) {
            params = new SnapshotParameters();
            params.setFill((Paint)Color.WHITE);
        }
        return this.snapshot(params, format, file);
    }

    private WritableImage snapshotImpl(final SnapshotParameters params) {
        if (Platform.isFxApplicationThread()) {
            return this.snapshotImplInJFX(params);
        }
        new JFXPanel();
        FutureTask<WritableImage> future = new FutureTask<WritableImage>(new Callable<WritableImage>(){

            @Override
            public WritableImage call() throws Exception {
                WritableImage img = SVGImage.this.snapshotImplInJFX(params);
                return img;
            }
        });
        Platform.runLater(future);
        try {
            return future.get();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

