/*
 * Decompiled with CFR 0.152.
 */
package com.here.oksse;

import com.here.oksse.ServerSentEvent;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;

class RealServerSentEvent
implements ServerSentEvent {
    private final ServerSentEvent.Listener listener;
    private final Request originalRequest;
    private OkHttpClient client;
    private Call call;
    private Reader sseReader;
    private long reconnectTime = TimeUnit.SECONDS.toMillis(3L);
    private long readTimeoutMillis = 0L;
    private String lastEventId;

    RealServerSentEvent(Request request, ServerSentEvent.Listener listener) {
        if (!"GET".equals(request.method())) {
            throw new IllegalArgumentException("Request must be GET: " + request.method());
        }
        this.originalRequest = request;
        this.listener = listener;
    }

    void connect(OkHttpClient client) {
        this.client = client;
        this.prepareCall(this.originalRequest);
        this.enqueue();
    }

    private void prepareCall(Request request) {
        if (this.client == null) {
            throw new AssertionError((Object)"Client is null");
        }
        Request.Builder requestBuilder = request.newBuilder().header("Accept-Encoding", "").header("Accept", "text/event-stream").header("Cache-Control", "no-cache");
        if (this.lastEventId != null) {
            requestBuilder.header("Last-Event-Id", this.lastEventId);
        }
        this.call = this.client.newCall(requestBuilder.build());
    }

    private void enqueue() {
        this.call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                RealServerSentEvent.this.notifyFailure(e, null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    RealServerSentEvent.this.openSse(response);
                } else {
                    RealServerSentEvent.this.notifyFailure(new IOException(response.message()), response);
                }
            }
        });
    }

    private void openSse(Response response) {
        this.sseReader = new Reader(response.body().source());
        this.sseReader.setTimeout(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        this.listener.onOpen(this, response);
        while (this.call != null && !this.call.isCanceled() && this.sseReader.read()) {
        }
    }

    private void notifyFailure(Throwable throwable, Response response) {
        if (!this.retry(throwable, response)) {
            this.listener.onClosed(this);
            this.close();
        }
    }

    private boolean retry(Throwable throwable, Response response) {
        if (!Thread.currentThread().isInterrupted() && !this.call.isCanceled() && this.listener.onRetryError(this, throwable, response)) {
            Request request = this.listener.onPreRetry(this, this.originalRequest);
            if (request == null) {
                return false;
            }
            this.prepareCall(request);
            try {
                Thread.sleep(this.reconnectTime);
            }
            catch (InterruptedException ignored) {
                return false;
            }
            if (!Thread.currentThread().isInterrupted() && !this.call.isCanceled()) {
                this.enqueue();
                return true;
            }
        }
        return false;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public void setTimeout(long timeout, TimeUnit unit) {
        if (this.sseReader != null) {
            this.sseReader.setTimeout(timeout, unit);
        }
        this.readTimeoutMillis = unit.toMillis(timeout);
    }

    @Override
    public void close() {
        if (this.call != null && !this.call.isCanceled()) {
            this.call.cancel();
        }
    }

    private class Reader {
        private static final char COLON_DIVIDER = ':';
        private static final String UTF8_BOM = "\ufeff";
        private static final String DATA = "data";
        private static final String ID = "id";
        private static final String EVENT = "event";
        private static final String RETRY = "retry";
        private static final String DEFAULT_EVENT = "message";
        private static final String EMPTY_STRING = "";
        private final Pattern DIGITS_ONLY = Pattern.compile("^[\\d]+$");
        private final BufferedSource source;
        private StringBuilder data = new StringBuilder();
        private String eventName = "message";

        Reader(BufferedSource source) {
            this.source = source;
        }

        boolean read() {
            try {
                String line = this.source.readUtf8LineStrict();
                this.processLine(line);
            }
            catch (IOException e) {
                RealServerSentEvent.this.notifyFailure(e, null);
                return false;
            }
            return true;
        }

        void setTimeout(long timeout, TimeUnit unit) {
            if (this.source != null) {
                this.source.timeout().timeout(timeout, unit);
            }
        }

        private void processLine(String line) {
            if (line == null || line.isEmpty()) {
                this.dispatchEvent();
                return;
            }
            int colonIndex = line.indexOf(58);
            if (colonIndex == 0) {
                RealServerSentEvent.this.listener.onComment(RealServerSentEvent.this, line.substring(1).trim());
            } else if (colonIndex != -1) {
                String field = line.substring(0, colonIndex);
                String value = EMPTY_STRING;
                int valueIndex = colonIndex + 1;
                if (valueIndex < line.length()) {
                    if (line.charAt(valueIndex) == ' ') {
                        ++valueIndex;
                    }
                    value = line.substring(valueIndex);
                }
                this.processField(field, value);
            } else {
                this.processField(line, EMPTY_STRING);
            }
        }

        private void dispatchEvent() {
            if (this.data.length() == 0) {
                return;
            }
            String dataString = this.data.toString();
            if (dataString.endsWith("\n")) {
                dataString = dataString.substring(0, dataString.length() - 1);
            }
            RealServerSentEvent.this.listener.onMessage(RealServerSentEvent.this, RealServerSentEvent.this.lastEventId, this.eventName, dataString);
            this.data.setLength(0);
            this.eventName = DEFAULT_EVENT;
        }

        private void processField(String field, String value) {
            if (DATA.equals(field)) {
                this.data.append(value).append('\n');
            } else if (ID.equals(field)) {
                RealServerSentEvent.this.lastEventId = value;
            } else if (EVENT.equals(field)) {
                this.eventName = value;
            } else if (RETRY.equals(field) && this.DIGITS_ONLY.matcher(value).matches()) {
                long timeout = Long.parseLong(value);
                if (RealServerSentEvent.this.listener.onRetryTime(RealServerSentEvent.this, timeout)) {
                    RealServerSentEvent.this.reconnectTime = timeout;
                }
            }
        }
    }
}

