/*
 * Decompiled with CFR 0.152.
 */
package treeminer.util;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class TreeRepresentationUtils {
    public static final String TREE_NODE_SEPARATOR = " ";
    public static final String MOVE_UP_TOKEN = "-";

    private TreeRepresentationUtils() {
    }

    public static String addChildrenToNode(String node, List<String> children) {
        StringBuilder builder = new StringBuilder();
        builder.append(node);
        children.forEach(child -> {
            builder.append(TREE_NODE_SEPARATOR);
            builder.append((String)child);
            builder.append(TREE_NODE_SEPARATOR);
            builder.append(MOVE_UP_TOKEN);
        });
        return builder.toString();
    }

    public static String addNodeToTree(String tree, Pair<String, Integer> node) {
        if (tree == null || tree.equals("")) {
            return (String)node.getLeft();
        }
        if (tree.length() == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(tree);
            builder.append(TREE_NODE_SEPARATOR);
            builder.append((String)node.getLeft());
            builder.append(TREE_NODE_SEPARATOR);
            builder.append(MOVE_UP_TOKEN);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        String[] treeElements = tree.split(TREE_NODE_SEPARATOR);
        boolean foundNode = false;
        boolean attachedNode = false;
        int atNode = -1;
        for (int i = 0; i < treeElements.length - 1; ++i) {
            String treeElement = treeElements[i];
            if (!foundNode) {
                if (!treeElement.equals(MOVE_UP_TOKEN) && ++atNode == (Integer)node.getRight()) {
                    foundNode = true;
                    atNode = 0;
                }
                builder.append(treeElement);
                builder.append(TREE_NODE_SEPARATOR);
                continue;
            }
            if (!attachedNode) {
                if (atNode == 0) {
                    if (treeElements[i].equals(MOVE_UP_TOKEN)) {
                        builder.append((String)node.getLeft());
                        builder.append(TREE_NODE_SEPARATOR);
                        builder.append(MOVE_UP_TOKEN);
                        builder.append(TREE_NODE_SEPARATOR);
                        attachedNode = true;
                    } else {
                        --atNode;
                    }
                } else {
                    atNode = treeElement.equals(MOVE_UP_TOKEN) ? atNode + 1 : atNode - 1;
                }
                builder.append(treeElement);
                builder.append(TREE_NODE_SEPARATOR);
                continue;
            }
            builder.append(treeElement);
            builder.append(TREE_NODE_SEPARATOR);
        }
        if (!attachedNode) {
            if (atNode == 0) {
                builder.append((String)node.getLeft());
                builder.append(TREE_NODE_SEPARATOR);
                builder.append(MOVE_UP_TOKEN);
                builder.append(TREE_NODE_SEPARATOR);
                builder.append(treeElements[treeElements.length - 1]);
            } else {
                builder.append(treeElements[treeElements.length - 1]);
                builder.append(TREE_NODE_SEPARATOR);
                builder.append((String)node.getLeft());
                builder.append(TREE_NODE_SEPARATOR);
                builder.append(MOVE_UP_TOKEN);
            }
        } else {
            builder.append(treeElements[treeElements.length - 1]);
        }
        return builder.toString();
    }

    public static String makeRepresentationForBranch(List<String> nodes) {
        StringBuilder builder = new StringBuilder();
        nodes.forEach(node -> {
            builder.append((String)node);
            builder.append(TREE_NODE_SEPARATOR);
        });
        for (int i = 0; i < nodes.size() - 2; ++i) {
            builder.append(MOVE_UP_TOKEN);
            builder.append(TREE_NODE_SEPARATOR);
        }
        builder.append(MOVE_UP_TOKEN);
        return builder.toString();
    }

    public static int findNumberOfChildrenOfNode(String tree, int node) {
        String[] treeElements = tree.split(TREE_NODE_SEPARATOR);
        int atNode = -1;
        boolean foundNode = false;
        int numChildren = 0;
        for (String treeElement : treeElements) {
            if (!foundNode) {
                if (treeElement.equals(MOVE_UP_TOKEN) || ++atNode != node) continue;
                foundNode = true;
                atNode = 0;
                continue;
            }
            if (!treeElement.equals(MOVE_UP_TOKEN)) {
                ++atNode;
                ++numChildren;
                continue;
            }
            if (atNode == 0) break;
            --atNode;
        }
        return numChildren;
    }

    public static boolean containsSubtree(String tree, String subtree) {
        String[] treeElements = tree.split(TREE_NODE_SEPARATOR);
        String[] subTreeElements = subtree.split(TREE_NODE_SEPARATOR);
        int nextNode = 0;
        int childNum = 0;
        for (int i = 0; i < treeElements.length; ++i) {
            if (treeElements[i].equals(subTreeElements[nextNode])) {
                if (childNum == 0) {
                    if (++nextNode != subTreeElements.length) continue;
                    return true;
                }
                if (treeElements[i].equals(MOVE_UP_TOKEN)) {
                    --childNum;
                    continue;
                }
                ++childNum;
                continue;
            }
            if (nextNode == 0) continue;
            if (treeElements[i].equals(MOVE_UP_TOKEN)) {
                if (childNum > 0) {
                    --childNum;
                    continue;
                }
                --nextNode;
                continue;
            }
            ++childNum;
        }
        return false;
    }
}

