/*
 * Decompiled with CFR 0.152.
 */
package treeminer.initialization;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import treeminer.EquivalenceClass;
import treeminer.Scope;
import treeminer.initialization.TreeMinerGeneralInitializer;
import treeminer.scopelists.elements.ScopeListElement;
import treeminer.scopelists.elements.SimpleScopeListElement;
import treeminer.scopelists.representation.AScopeListRepresentation;
import treeminer.scopelists.representation.ScopeListRepresentation;
import treeminer.util.TreeRepresentationUtils;

public class TreeMinerNonDistinctInitializer {
    private TreeMinerNonDistinctInitializer() {
    }

    public static List<EquivalenceClass> initialize(EquivalenceClass f1, List<String> trees, int minSupport) {
        TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF2PatternToOccurence = new TreeMap<String, AScopeListRepresentation<ScopeListElement>>();
        TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF1PatternToOccurence = new TreeMap<String, AScopeListRepresentation<ScopeListElement>>();
        TreeMinerNonDistinctInitializer.generateCandidateScopeListsF1F2(f1, mapF2PatternToOccurence, mapF1PatternToOccurence);
        mapF1PatternToOccurence.forEach(f1::addScopeListFor);
        for (int i = 0; i < trees.size(); ++i) {
            TreeMinerNonDistinctInitializer.findPatternsInTree(trees.get(i), mapF2PatternToOccurence, mapF1PatternToOccurence, i);
        }
        List<EquivalenceClass> candidateEquivalenceClasses = TreeMinerGeneralInitializer.generateCandidateEquivalenceClassesF2(f1);
        return TreeMinerNonDistinctInitializer.filterF2CandidateClassesByPatternOccurrences(candidateEquivalenceClasses, mapF2PatternToOccurence, minSupport);
    }

    private static void generateCandidateScopeListsF1F2(EquivalenceClass f1, TreeMap<String, AScopeListRepresentation<ScopeListElement>> f2ScopeLists, TreeMap<String, AScopeListRepresentation<ScopeListElement>> f1ScopeLists) {
        f1.getElementList().forEach(pairX -> {
            f1ScopeLists.put((String)pairX.getLeft(), new ScopeListRepresentation());
            f1.getElementList().forEach(pairY -> {
                String pattern = String.format("%s%s%s%s%s", pairX.getLeft(), " ", pairY.getLeft(), " ", "-");
                ScopeListRepresentation occurrences = new ScopeListRepresentation();
                f2ScopeLists.put(pattern, occurrences);
            });
        });
    }

    private static void findPatternsInTree(String tree, TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF2PatternToOccurence, TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF1PatternToOccurence, int i) {
        String[] treeRepresentation = tree.split(" ");
        Scope[] nodeScopes = new Scope[(int)Math.ceil((double)treeRepresentation.length / 2.0)];
        String[] matchLabels = new String[(int)Math.ceil((double)treeRepresentation.length / 2.0)];
        TreeMinerNonDistinctInitializer.findNodeScopes(treeRepresentation, nodeScopes, matchLabels);
        TreeMinerNonDistinctInitializer.findCandidateFrequencies(mapF2PatternToOccurence, mapF1PatternToOccurence, i, treeRepresentation, nodeScopes, matchLabels);
    }

    private static void findNodeScopes(String[] treeRepresentation, Scope[] nodeScopes, String[] matchLabels) {
        for (int j = 0; j < nodeScopes.length; ++j) {
            nodeScopes[j] = new Scope();
        }
        int atNode = -1;
        ArrayList<Integer> openScopes = new ArrayList<Integer>();
        StringBuilder matchLabelBuilder = new StringBuilder();
        for (String treeElement : treeRepresentation) {
            if (!treeElement.equals("-")) {
                nodeScopes[++atNode].setLowerBound(atNode);
                openScopes.add(atNode);
                matchLabels[atNode] = matchLabelBuilder.toString().trim();
            } else {
                int closeScopeIndex = (Integer)openScopes.get(openScopes.size() - 1);
                nodeScopes[closeScopeIndex].setUpperBound(atNode);
                openScopes.remove(openScopes.get(openScopes.size() - 1));
            }
            matchLabelBuilder.append(treeElement);
            matchLabelBuilder.append(" ");
        }
        nodeScopes[0].setUpperBound(nodeScopes.length - 1);
    }

    private static void findCandidateFrequencies(TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF2PatternToOccurence, TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF1PatternToOccurence, int i, String[] treeRepresentation, Scope[] nodeScopes, String[] matchLabels) {
        int atNode = -1;
        for (int j = 0; j < treeRepresentation.length; ++j) {
            String treeElement = treeRepresentation[j];
            if (treeElement.equals("-")) continue;
            TreeMinerNonDistinctInitializer.addNewPattern(mapF1PatternToOccurence, i, nodeScopes, matchLabels, ++atNode, treeElement);
            TreeMinerNonDistinctInitializer.checkForDoublePattern(mapF2PatternToOccurence, i, treeRepresentation, nodeScopes, matchLabels, atNode, j, treeElement);
        }
    }

    private static void addNewPattern(TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF1PatternToOccurence, int i, Scope[] nodeScopes, String[] matchLabels, int atNode, String treeElement) {
        ScopeListElement entry = new ScopeListElement(i, matchLabels[atNode], nodeScopes[atNode]);
        if (mapF1PatternToOccurence.get(treeElement) != null) {
            mapF1PatternToOccurence.get(treeElement).add(entry);
        }
    }

    private static void checkForDoublePattern(TreeMap<String, AScopeListRepresentation<ScopeListElement>> mapF2PatternToOccurence, int i, String[] treeRepresentation, Scope[] nodeScopes, String[] matchLabels, int atNode, int j, String treeElement) {
        int childLevel = 0;
        int childNumber = 0;
        for (int k = j + 1; k < treeRepresentation.length; ++k) {
            String potentialChild = treeRepresentation[k];
            if (!potentialChild.equals("-")) {
                ++childLevel;
                ScopeListElement f2entry = new ScopeListElement(i, matchLabels[atNode], nodeScopes[atNode + ++childNumber]);
                AScopeListRepresentation<ScopeListElement> list = mapF2PatternToOccurence.get(String.format("%s%s%s%s%s", treeElement, " ", treeRepresentation[k], " ", "-"));
                if (list == null) continue;
                list.add(f2entry);
                continue;
            }
            if (--childLevel == -1) break;
        }
    }

    public static List<EquivalenceClass> filterF2CandidateClassesByPatternOccurrences(List<EquivalenceClass> candidateEquivalenceClasses, SortedMap<String, AScopeListRepresentation<ScopeListElement>> mapF2PatternToOccurence, int minSupport) {
        ArrayList<EquivalenceClass> newEquivalenceClasses = new ArrayList<EquivalenceClass>();
        candidateEquivalenceClasses.forEach(equivalenceClass -> {
            TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> scopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
            equivalenceClass.getElementList().forEach(element -> {
                String label = TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), (Pair<String, Integer>)element);
                AScopeListRepresentation scopeList = (AScopeListRepresentation)mapF2PatternToOccurence.get(label);
                scopeLists.put(label, scopeList);
            });
            equivalenceClass.setScopeLists(scopeLists);
            equivalenceClass.discardNonFrequentElements(minSupport);
            if (!equivalenceClass.getElementList().isEmpty()) {
                newEquivalenceClasses.add((EquivalenceClass)equivalenceClass);
            }
        });
        return newEquivalenceClasses;
    }
}

