/*
 * Decompiled with CFR 0.152.
 */
package treeminer;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import treeminer.EquivalenceClass;
import treeminer.FrequentSubtreeFinder;
import treeminer.initialization.TreeMinerGeneralInitializer;
import treeminer.scopelists.elements.SimpleScopeListElement;
import treeminer.scopelists.representation.AScopeListRepresentation;
import treeminer.util.ScopeListRepresentationUtils;
import treeminer.util.TreeRepresentationUtils;

public class TreeMiner
implements FrequentSubtreeFinder {
    private int minSupport;
    private int numTrees;
    private List<EquivalenceClass> foundEquivalenceClasses;
    private int numFoundPatterns;
    private boolean countMultipleOccurrences = true;
    private boolean onlySearchForPatternsThatStartWithTheRoot = false;

    @Override
    public List<String> findFrequentSubtrees(List<String> trees, int minSupport) {
        this.minSupport = minSupport;
        this.numTrees = trees.size();
        this.foundEquivalenceClasses = new ArrayList<EquivalenceClass>();
        EquivalenceClass f1 = TreeMinerGeneralInitializer.findFrequentF1Subtrees(trees, minSupport);
        if (this.onlySearchForPatternsThatStartWithTheRoot) {
            EquivalenceClass newF1 = new EquivalenceClass(f1.getPrefix());
            f1.getElementList().forEach(pair -> {
                for (String tree : trees) {
                    if (!tree.split(" ")[0].equals(pair.getLeft())) continue;
                    newF1.addElement((Pair<String, Integer>)pair);
                    break;
                }
            });
            this.foundEquivalenceClasses.add(newF1);
        } else {
            this.foundEquivalenceClasses.add(f1);
        }
        List<EquivalenceClass> f2Classes = TreeMinerGeneralInitializer.findFrequentF2Subtrees(f1, trees, this.countMultipleOccurrences, minSupport);
        if (this.onlySearchForPatternsThatStartWithTheRoot) {
            this.foundEquivalenceClasses.get(0).getElementList().forEach(pair -> this.foundEquivalenceClasses.get(0).addScopeListFor((String)pair.getLeft(), f1.getScopeListFor((String)pair.getLeft())));
            f2Classes.forEach(equivalenceClass -> {
                for (String tree : trees) {
                    if (!tree.split(" ")[0].equals(equivalenceClass.getPrefix())) continue;
                    this.foundEquivalenceClasses.add((EquivalenceClass)equivalenceClass);
                    break;
                }
            });
        } else {
            this.foundEquivalenceClasses.addAll(f2Classes);
        }
        f2Classes.forEach(elem -> this.findFrequentSubtrees((EquivalenceClass)elem, trees));
        TreeSet foundFrequentTrees = new TreeSet();
        this.foundEquivalenceClasses.forEach(foundClass -> foundFrequentTrees.addAll(this.extractNonEmbeddedFrequentTrees((EquivalenceClass)foundClass, trees)));
        this.numFoundPatterns = foundFrequentTrees.size();
        return new ArrayList<String>(foundFrequentTrees);
    }

    private void findFrequentSubtrees(EquivalenceClass equivalenceClass, List<String> trees) {
        for (Pair<String, Integer> XIelement : equivalenceClass.getElementList()) {
            String newPrefix = TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), XIelement);
            if (!ScopeListRepresentationUtils.prefixOccursDirectly(equivalenceClass, trees, newPrefix)) continue;
            EquivalenceClass pXi = new EquivalenceClass(newPrefix);
            this.findMembersOfEquivalenceClass(equivalenceClass, XIelement, pXi);
            if (pXi.getElementList().isEmpty()) continue;
            System.out.println("Find Members of Class");
            System.out.println(pXi);
            this.foundEquivalenceClasses.add(pXi);
            this.findFrequentSubtrees(pXi, trees);
        }
    }

    private void findMembersOfEquivalenceClass(EquivalenceClass equivalenceClass, Pair<String, Integer> xIElement, EquivalenceClass pXi) {
        for (Pair<String, Integer> YJElement : equivalenceClass.getElementList()) {
            if (xIElement.getRight() == YJElement.getRight()) {
                this.checkCase1(equivalenceClass, xIElement, pXi, YJElement);
                continue;
            }
            if ((Integer)xIElement.getRight() <= (Integer)YJElement.getRight()) continue;
            this.checkCase2(equivalenceClass, xIElement, pXi, YJElement);
        }
    }

    private void checkCase1(EquivalenceClass equivalenceClass, Pair<String, Integer> xIElement, EquivalenceClass pXi, Pair<String, Integer> yJElement) {
        AScopeListRepresentation<? extends SimpleScopeListElement> xScopeList = equivalenceClass.getScopeListFor(TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), xIElement));
        AScopeListRepresentation<? extends SimpleScopeListElement> yScopeList = equivalenceClass.getScopeListFor(TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), yJElement));
        if (xScopeList == null) {
            return;
        }
        AScopeListRepresentation<? extends SimpleScopeListElement> newScopeList = ScopeListRepresentationUtils.doInScopeJoin(xScopeList, yScopeList, this.countMultipleOccurrences);
        if (newScopeList.size() >= this.minSupport) {
            int numberOfChildrenOfParentNode = TreeRepresentationUtils.findNumberOfChildrenOfNode(equivalenceClass.getPrefix(), (Integer)xIElement.getRight());
            int newXPosition = (Integer)xIElement.getRight() + 1 + numberOfChildrenOfParentNode;
            ImmutablePair newElement = new ImmutablePair(yJElement.getLeft(), (Object)newXPosition);
            pXi.addElement((Pair<String, Integer>)newElement);
            pXi.addScopeListFor(TreeRepresentationUtils.addNodeToTree(pXi.getPrefix(), (Pair<String, Integer>)newElement), newScopeList);
        }
        if ((newScopeList = ScopeListRepresentationUtils.doOutScopeJoin(yJElement, xScopeList, yScopeList, this.countMultipleOccurrences)).size() >= this.minSupport) {
            pXi.addElement(yJElement);
            pXi.addScopeListFor(TreeRepresentationUtils.addNodeToTree(pXi.getPrefix(), yJElement), newScopeList);
        }
    }

    private void checkCase2(EquivalenceClass equivalenceClass, Pair<String, Integer> xIElement, EquivalenceClass pXi, Pair<String, Integer> yJElement) {
        AScopeListRepresentation<? extends SimpleScopeListElement> xScopeList = equivalenceClass.getScopeListFor(TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), xIElement));
        AScopeListRepresentation<? extends SimpleScopeListElement> yScopeList = equivalenceClass.getScopeListFor(TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), yJElement));
        if (xScopeList == null) {
            return;
        }
        AScopeListRepresentation<? extends SimpleScopeListElement> newScopeList = ScopeListRepresentationUtils.doOutScopeJoin(yJElement, xScopeList, yScopeList, this.countMultipleOccurrences);
        if (newScopeList.size() >= this.minSupport) {
            pXi.addElement(yJElement);
            pXi.addScopeListFor(TreeRepresentationUtils.addNodeToTree(pXi.getPrefix(), yJElement), newScopeList);
        }
    }

    protected TreeSet<String> extractNonEmbeddedFrequentTrees(EquivalenceClass equivalenceClass, List<String> trees) {
        TreeSet<String> foundTrees = new TreeSet<String>();
        TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>> newScopeLists = new TreeMap<String, AScopeListRepresentation<? extends SimpleScopeListElement>>();
        ArrayList<Pair<String, Integer>> newElementList = new ArrayList<Pair<String, Integer>>();
        for (int i = 0; i < equivalenceClass.getElementList().size(); ++i) {
            String subTree = TreeRepresentationUtils.addNodeToTree(equivalenceClass.getPrefix(), equivalenceClass.getElementList().get(i));
            AScopeListRepresentation<? extends SimpleScopeListElement> scopeList = equivalenceClass.getScopeListFor(subTree);
            int support = 0;
            for (SimpleScopeListElement simpleScopeListElement : scopeList) {
                if (!TreeRepresentationUtils.containsSubtree(trees.get(simpleScopeListElement.getTreeIndex()), subTree)) continue;
                ++support;
            }
            if (support < this.minSupport) continue;
            foundTrees.add(subTree);
            newScopeLists.put(subTree, scopeList);
            newElementList.add(equivalenceClass.getElementList().get(i));
        }
        equivalenceClass.setScopeLists(newScopeLists);
        equivalenceClass.setElementList(newElementList);
        return foundTrees;
    }

    @Override
    public List<EquivalenceClass> getFoundEquivalenceClasses() {
        return this.foundEquivalenceClasses;
    }

    @Override
    public double[][] getCharacterizationsOfTrainingExamples() {
        double[][] treesWithPatternOccurrences = new double[this.numTrees][this.numFoundPatterns];
        int currentPattern = 0;
        for (EquivalenceClass equivalenceClass : this.foundEquivalenceClasses) {
            for (String pattern : equivalenceClass.getScopeLists().keySet()) {
                for (SimpleScopeListElement simpleScopeListElement : equivalenceClass.getScopeListFor(pattern)) {
                    treesWithPatternOccurrences[simpleScopeListElement.getTreeIndex()][currentPattern] = 1.0;
                }
                ++currentPattern;
            }
        }
        return treesWithPatternOccurrences;
    }

    public void setCountMultipleOccurrences(boolean countMultipleOccurrences) {
        this.countMultipleOccurrences = countMultipleOccurrences;
    }

    public boolean getOnlySearchForPatternsThatStartWithTheRoot() {
        return this.onlySearchForPatternsThatStartWithTheRoot;
    }

    public void setOnlySearchForPatternsThatStartWithTheRoot(boolean onlySearchForPatternsThatStartWithTheRoot) {
        this.onlySearchForPatternsThatStartWithTheRoot = onlySearchForPatternsThatStartWithTheRoot;
    }
}

